/*
 * Decompiled with CFR 0.152.
 */
package grid.matrix;

import grid.Grid;
import grid.matrix.NumberTile;
import java.util.Arrays;

public class Matrix
extends Grid<NumberTile<Double>> {
    public Matrix(Integer ... bounds) {
        super(bounds);
    }

    public Matrix(int[] bounds) {
        super(bounds);
    }

    public boolean hasBounds(int[] bounds) {
        return Arrays.equals(this.bounds, bounds);
    }

    public double getVal(Integer ... loc) {
        NumberTile tile = (NumberTile)this.get(loc);
        if (tile != null) {
            return (Double)tile.getVal();
        }
        return 0.0;
    }

    public Matrix add(Matrix m) {
        if (!this.hasBounds(m.bounds)) {
            throw new RuntimeException();
        }
        Matrix mx = new Matrix(this.bounds);
        for (Integer[] loc : this.buildCoordinates()) {
            mx.add(new NumberTile<Double>(this.getVal(loc) + m.getVal(loc), loc));
        }
        return mx;
    }
}

