/*
 * Decompiled with CFR 0.152.
 */
package grid;

import common.Util;
import common.dataStructures.ConsList;
import grid.Tile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BinaryOperator;

public class Grid<T extends Tile>
implements Collection<T>,
Cloneable {
    protected final Object[] vals;
    protected final int[] bounds;
    public final int dimension;
    private int size;

    public Grid(Integer ... bounds) {
        this.dimension = bounds.length;
        this.bounds = new int[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            this.bounds[i] = bounds[i];
        }
        this.vals = this.recCreateArrays(0);
        this.size = 0;
    }

    public Grid(int[] bounds) {
        this.dimension = bounds.length;
        this.bounds = Arrays.copyOf(bounds, bounds.length);
        this.vals = this.recCreateArrays(0);
        this.size = 0;
    }

    public static <T extends Tile> Grid<T> merge(Grid<? extends T> grid1, Grid<? extends T> grid2, BinaryOperator<T> combinor) throws IllegalDimensionException {
        if (grid1.dimension != grid2.dimension) {
            throw new IllegalDimensionException(grid2.dimension, grid1);
        }
        Integer[] bounds = new Integer[grid1.dimension];
        for (int i = 0; i < grid1.dimension; ++i) {
            bounds[i] = Math.max(grid1.bounds[i], grid2.bounds[i]);
        }
        Grid<Tile> grid = new Grid<Tile>(bounds);
        for (Integer[] loc : grid.buildCoordinates()) {
            grid.add((Tile)combinor.apply(grid1.getSafe(loc), grid2.getSafe(loc)));
        }
        return grid;
    }

    public Grid<T> union(Grid<? extends T> other) throws IllegalDimensionException {
        return Grid.merge(this, other, (t, t2) -> t != null ? t : t2);
    }

    private Object[] recCreateArrays(int depth) {
        if (this.vals != null) {
            throw new RuntimeException("Can't call recCreateArrays not at construction time");
        }
        if (depth == this.bounds.length) {
            return null;
        }
        Object[] vals = new Object[this.bounds[depth]];
        for (int i = 0; i < this.bounds[depth]; ++i) {
            vals[i] = this.recCreateArrays(depth + 1);
        }
        return vals;
    }

    public int[] getBounds() {
        return Arrays.copyOf(this.bounds, this.bounds.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public T get(Integer ... loc) {
        if (loc.length != this.dimension) {
            throw new IllegalDimensionException(loc.length, this);
        }
        return this.recGetTile(this.vals, 0, loc);
    }

    public T getSafe(Integer ... loc) {
        if (loc.length != this.dimension) {
            return null;
        }
        try {
            return this.recGetTile(this.vals, 0, loc);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public List<T> getAll() {
        LinkedList<Tile> l = new LinkedList<Tile>();
        for (Tile t : this) {
            l.add(t);
        }
        return l;
    }

    public T getFrom(Tile base, Integer ... delta) {
        if (delta.length != this.dimension) {
            throw new IllegalDimensionException(delta.length, this);
        }
        Integer[] d = Arrays.copyOf(base.getLocation(), delta.length);
        for (int i = 0; i < d.length; ++i) {
            Integer[] integerArray = d;
            int n = i;
            Integer.valueOf(integerArray[n] + delta[i]);
        }
        return this.get(d);
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.size];
        int i = 0;
        for (Tile t : this) {
            arr[i] = t;
            ++i;
        }
        return arr;
    }

    @Override
    public <X> X[] toArray(X[] a) {
        X[] a2 = null;
        a2 = a.length >= this.size ? a : Arrays.copyOf(a, this.size);
        int i = 0;
        for (Tile t : this) {
            a2[i] = t;
            ++i;
        }
        return a2;
    }

    public Map<List<Integer>, T> toMap() {
        HashMap<List<Integer>, Tile> m = new HashMap<List<Integer>, Tile>();
        for (Tile t : this) {
            m.put(Collections.unmodifiableList(Arrays.asList(t.getLocation())), t);
        }
        return m;
    }

    public boolean containsAt(Integer ... loc) throws IllegalDimensionException {
        if (loc.length != this.dimension) {
            throw new IllegalDimensionException(loc.length, this);
        }
        return this.get(loc) != null;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Tile)) {
            return false;
        }
        return (Tile)o == this.get(((Tile)o).getLocation());
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(T t) {
        if (this.get(t.getLocation()) == t) {
            return false;
        }
        if (!this.containsAt(t.getLocation())) {
            ++this.size;
        }
        this.recSetTile(this.vals, 0, t.getLocation(), t);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean b = false;
        for (Tile t : c) {
            b = this.add((T)t) || b;
        }
        return b;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Tile)) {
            return false;
        }
        Tile t = (Tile)o;
        T t2 = this.get(t.getLocation());
        if (t == t2) {
            this.recSetTile(this.vals, 0, t.getLocation(), null);
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean b = true;
        for (Object t : c) {
            b = this.remove(t) && b;
        }
        return b;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean b = false;
        for (Tile t : this.toArray((X[])new Tile[0])) {
            if (c.contains(t)) continue;
            b = this.remove(t) || b;
        }
        return b;
    }

    @Override
    public void clear() {
        for (Tile t : this.toArray((X[])new Tile[0])) {
            this.remove(t);
        }
    }

    public T remove(Integer ... pos) {
        if (pos.length != this.dimension) {
            throw new IllegalDimensionException(pos.length, this);
        }
        T t = this.get(pos);
        if (t != null) {
            this.remove(t);
        }
        return t;
    }

    private T recGetTile(Object[] arr, int depth, Integer[] loc) {
        int index = loc[depth];
        if (depth == this.dimension - 1) {
            return (T)((Tile)arr[index]);
        }
        return this.recGetTile((Object[])arr[index], depth + 1, loc);
    }

    private void recSetTile(Object[] arr, int depth, Integer[] loc, T t) {
        int index = loc[depth];
        if (depth == this.dimension - 1) {
            arr[index] = t;
        } else {
            this.recSetTile((Object[])arr[index], depth + 1, loc, t);
        }
    }

    public ArrayList<Integer[]> buildCoordinates() {
        return Grid.recBuild(new ConsList<Integer>(), new ArrayList<Integer[]>(), 0, this.bounds);
    }

    private static ArrayList<Integer[]> recBuild(ConsList<Integer> template, ArrayList<Integer[]> built, int depth, int[] bounds) {
        if (depth == bounds.length) {
            built.add(template.reverse().toArray(new Integer[template.size]));
            return built;
        }
        for (int i = 0; i < bounds[depth]; ++i) {
            Grid.recBuild(template.cons(i), built, depth + 1, bounds);
        }
        return built;
    }

    public String toString() {
        return Arrays.deepToString(this.vals);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Grid)) {
            return false;
        }
        Grid g = (Grid)o;
        return Arrays.deepEquals(this.vals, g.vals);
    }

    @Override
    public int hashCode() {
        return Arrays.deepHashCode(this.vals);
    }

    @Override
    public Iterator<T> iterator() {
        return new GridIterator();
    }

    public Grid<T> clone() {
        return this.clone(Util.boxArr(this.bounds));
    }

    public Grid<T> clone(Integer ... bounds) {
        if (bounds.length != this.bounds.length) {
            throw new IllegalDimensionException(bounds.length, this);
        }
        Grid<Tile> g = new Grid<Tile>(bounds);
        for (Tile t : this) {
            try {
                g.add(t);
            }
            catch (ArrayIndexOutOfBoundsException e) {}
        }
        return g;
    }

    public Grid<T> resize(Integer ... bounds) {
        return this.clone(bounds);
    }

    class GridIterator
    implements Iterator<T> {
        private Integer[] pos;
        private boolean next;

        public GridIterator() {
            this.pos = new Integer[Grid.this.dimension];
            for (int i = 0; i < Grid.this.dimension; ++i) {
                this.pos[i] = 0;
            }
            this.next = Grid.this.dimension > 0 && Grid.this.size > 0;
        }

        @Override
        public boolean hasNext() {
            return this.next;
        }

        @Override
        public T next() {
            while (!Grid.this.containsAt(this.pos)) {
                if (this.recInc(Grid.this.dimension - 1)) continue;
                throw new NoSuchElementException();
            }
            Object t = Grid.this.get(this.pos);
            this.next = this.recInc(Grid.this.dimension - 1);
            while (this.next && !Grid.this.containsAt(this.pos)) {
                this.next = this.recInc(Grid.this.dimension - 1);
            }
            return t;
        }

        private boolean recInc(int depth) {
            if (depth == -1) {
                return false;
            }
            Integer[] integerArray = this.pos;
            int n = depth;
            Integer n2 = integerArray[n];
            Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
            if (this.pos[depth] == Grid.this.bounds[depth]) {
                this.pos[depth] = 0;
                return this.recInc(depth - 1);
            }
            return true;
        }

        @Override
        public void remove() {
            Object t = this.next();
            Grid.this.remove(t);
        }
    }

    static class IllegalDimensionException
    extends RuntimeException {
        public IllegalDimensionException(int d, Grid<?> g) {
            super("Illegal Dimension: " + d + " for Grid with dimension " + g.dimension);
        }
    }
}

