/*
 * Decompiled with CFR 0.152.
 */
package graph.matching;

import common.dataStructures.BiMap;
import common.types.Either;
import common.types.Left;
import common.types.Right;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Matching<A, B> {
    private HashSet<A> aObjects = new HashSet();
    private HashSet<B> bObjects = new HashSet();
    private BiMap<A, B> matching = new BiMap();

    public Matching() {
    }

    public Matching(Set<? extends A> aObjs, Set<? extends B> bObjs) {
        this();
        this.addAllA(aObjs);
        this.addAllB(bObjs);
    }

    public boolean addA(A a) {
        if (this.aObjects.contains(a)) {
            return false;
        }
        this.aObjects.add(a);
        return true;
    }

    public boolean addAllA(Collection<? extends A> colA) {
        boolean changed = false;
        for (A a : colA) {
            changed = this.addA(a) | changed;
        }
        return changed;
    }

    public boolean addB(B b) {
        if (this.bObjects.contains(b)) {
            return false;
        }
        this.bObjects.add(b);
        return true;
    }

    public boolean addAllB(Collection<? extends B> colB) {
        boolean changed = false;
        for (B b : colB) {
            changed = this.addB(b) | changed;
        }
        return changed;
    }

    public boolean contains(Object o) {
        return this.aObjects.contains(o) || this.bObjects.contains(o);
    }

    public boolean isMatched(Object o) {
        return this.matching.containsKey(o) || this.matching.containsValue(o);
    }

    public boolean isUnmatched(Object o) {
        return (this.aObjects.contains(o) || this.bObjects.contains(o)) && !this.isMatched(o);
    }

    public A getMatchedA(B b) {
        return this.matching.getKey(b);
    }

    public B getMatchedB(A a) {
        return this.matching.getValue(a);
    }

    public boolean match(A a, B b) {
        if (!this.aObjects.contains(a) || !this.bObjects.contains(b)) {
            return false;
        }
        this.matching.put(a, b);
        return true;
    }

    public BiMap<A, B> getMatching() {
        return this.matching.clone();
    }

    public BiMap<B, A> getFlippedMatching() {
        return this.matching.flip();
    }

    public Set<A> getMatchedA() {
        HashSet<A> obj = new HashSet<A>();
        for (A a : this.aObjects) {
            if (!this.matching.containsKey(a)) continue;
            obj.add(a);
        }
        return obj;
    }

    public Set<B> getMatchedB() {
        HashSet<B> obj = new HashSet<B>();
        for (B b : this.bObjects) {
            if (!this.matching.containsValue(b)) continue;
            obj.add(b);
        }
        return obj;
    }

    public Set<A> getUnmatchedA() {
        HashSet<A> obj = new HashSet<A>();
        for (A a : this.aObjects) {
            if (this.matching.containsKey(a)) continue;
            obj.add(a);
        }
        return obj;
    }

    public Set<B> getUnmatchedB() {
        HashSet<B> obj = new HashSet<B>();
        for (B b : this.bObjects) {
            if (this.matching.containsValue(b)) continue;
            obj.add(b);
        }
        return obj;
    }

    public HashSet<Either<A, B>> getMatched() {
        HashSet<Either<A, B>> obj = new HashSet<Either<A, B>>();
        for (A a : this.getMatchedA()) {
            obj.add(new Left(a));
        }
        for (Object b : this.getMatchedB()) {
            obj.add(new Right(b));
        }
        return obj;
    }

    public HashSet<Either<A, B>> getUnmatched() {
        HashSet<Either<A, B>> obj = new HashSet<Either<A, B>>();
        for (A a : this.getUnmatchedA()) {
            obj.add(new Left(a));
        }
        for (Object b : this.getUnmatchedB()) {
            obj.add(new Right(b));
        }
        return obj;
    }

    public boolean equals(Object o) {
        try {
            Matching m = (Matching)o;
            return this.aObjects.equals(m.aObjects) && this.bObjects.equals(m.bObjects) && this.matching.equals(m.matching);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return Objects.hash(this.aObjects, this.bObjects, this.matching);
    }

    public String toString() {
        String unmatched = "[";
        for (Either<A, B> e : this.getUnmatched()) {
            unmatched = unmatched + e.getVal().toString() + ", ";
        }
        unmatched = unmatched.substring(0, unmatched.length() - 2) + "]";
        return this.matching.toString() + ", Unmatched: " + unmatched;
    }
}

