/*
 * Decompiled with CFR 0.152.
 */
package graph.matching;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;

public interface Agent<X> {
    public Map<X, Integer> getPreferences();

    public static <X> boolean isAcceptable(Agent<X> a, X x) {
        return a.getPreferences().containsKey(x);
    }

    public static <X> boolean prefers(Agent<X> a, X x1, X x2) {
        Map<X, Integer> pref = a.getPreferences();
        return pref.getOrDefault(x1, Integer.MIN_VALUE) > pref.getOrDefault(x2, Integer.MIN_VALUE);
    }

    public static <X> boolean prefersWeakly(Agent<X> a, X x1, X x2) {
        Map<X, Integer> pref = a.getPreferences();
        return pref.getOrDefault(x1, Integer.MIN_VALUE) >= pref.getOrDefault(x2, Integer.MIN_VALUE);
    }

    public static <X> Collection<X> perfersSet(Agent<X> a, X x) {
        HashSet<X> h = new HashSet<X>();
        Map<X, Integer> pref = a.getPreferences();
        int val = pref.getOrDefault(x, Integer.MIN_VALUE);
        for (Map.Entry<X, Integer> e : pref.entrySet()) {
            if (e.getValue() <= val) continue;
            h.add(e.getKey());
        }
        return Collections.unmodifiableSet(h);
    }

    public static <X> Collection<X> perfersWeaklySet(Agent<X> a, X x) {
        HashSet<X> h = new HashSet<X>();
        Map<X, Integer> pref = a.getPreferences();
        int val = pref.getOrDefault(x, Integer.MIN_VALUE);
        for (Map.Entry<X, Integer> e : pref.entrySet()) {
            if (e.getValue() < val) continue;
            h.add(e.getKey());
        }
        return Collections.unmodifiableSet(h);
    }
}

