/*
 * Decompiled with CFR 0.152.
 */
package graph;

import common.dataStructures.NotInCollectionException;
import graph.Graph;
import graph.SimpleEdge;
import graph.SimpleVertex;
import java.util.HashMap;

public class SimpleGraph
extends Graph<SimpleVertex, SimpleEdge> {
    private HashMap<Integer, SimpleVertex> idToVertex;
    private HashMap<Integer, SimpleEdge> idToEdge;

    public SimpleGraph() {
        this.idToVertex = new HashMap();
        this.idToEdge = new HashMap();
    }

    public SimpleGraph(boolean directed) {
        super(directed);
        this.idToVertex = new HashMap();
        this.idToEdge = new HashMap();
    }

    public SimpleGraph(Graph<SimpleVertex, SimpleEdge> g) {
        super(g.isDirected());
        for (SimpleVertex v : g.vertexSet()) {
            this.addVertex(v.clone());
        }
        for (SimpleEdge e : g.edgeSet()) {
            Graph.Edge edge = g.getEdge(e);
            this.addEdge((SimpleVertex)edge.getSource().v, (SimpleVertex)edge.getSink().v, e.clone());
        }
    }

    @Override
    public SimpleGraph clone() {
        return new SimpleGraph(this);
    }

    @Override
    public boolean addVertex(SimpleVertex v) {
        boolean added = super.addVertex(v);
        if (added) {
            this.idToVertex.put(v.getID(), v);
        }
        return added;
    }

    @Override
    public boolean addEdge(SimpleVertex v1, SimpleVertex v2, SimpleEdge e) throws NotInCollectionException {
        boolean added = super.addEdge(v1, v2, e);
        if (added) {
            this.idToEdge.put(e.getID(), e);
        }
        return added;
    }

    public int addVertex() {
        SimpleVertex s = new SimpleVertex();
        this.addVertex(s);
        return s.getID();
    }

    public int addEdge(SimpleVertex source, SimpleVertex sink) throws NotInCollectionException {
        SimpleEdge e = new SimpleEdge();
        boolean added = this.addEdge(source, sink, e);
        return added ? e.getID() : -1;
    }

    @Override
    public boolean removeVertex(SimpleVertex v) {
        boolean removed = super.removeVertex(v);
        if (removed) {
            this.idToVertex.remove(v.getID());
        }
        return removed;
    }

    @Override
    public boolean removeEdge(SimpleEdge e) {
        boolean removed = super.removeEdge(e);
        if (removed) {
            this.idToEdge.remove(e.getID());
        }
        return removed;
    }

    @Override
    public boolean removeVertex(int id) {
        if (!this.idToVertex.containsKey(id)) {
            return false;
        }
        super.removeVertex(this.idToVertex.get(id));
        return true;
    }

    @Override
    public boolean removeEdge(int id) {
        if (!this.idToEdge.containsKey(id)) {
            return false;
        }
        super.removeEdge(this.idToEdge.get(id));
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.idToVertex.clear();
        this.idToEdge.clear();
    }
}

