/*
 * Decompiled with CFR 0.152.
 */
package graph;

import functional.Function;
import graph.Graph;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class GraphPanel<V, E>
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final Font STRING_FONT = Font.decode("Arial-10");
    protected HashMap<V, Circle> nodes;
    protected HashMap<E, Line> edges;
    private final boolean directed;
    private Function<Circle, String> circleStringToDrawFunc;
    private Function<Line, String> lineStringToDrawFunc;
    private Function<Line, Stroke> lineStrokeFunc;
    private Dimension size = new Dimension(500, 500);
    private final JSlider sizeSlider;

    public GraphPanel(Graph<V, E> graph) {
        this.directed = graph.isDirected();
        this.nodes = new HashMap();
        this.edges = new HashMap();
        this.lineStrokeFunc = l -> new BasicStroke();
        this.circleStringToDrawFunc = c -> ((Circle)c).represents.toString();
        this.lineStringToDrawFunc = l -> ((Line)l).represents.toString();
        this.setLayout(new BorderLayout());
        this.setLayout(null);
        this.setPreferredSize(this.size);
        this.setBackground(Color.WHITE);
        this.sizeSlider = new JSlider();
        this.sizeSlider.setMinimum(5);
        this.sizeSlider.setMaximum(75);
        this.addGraph(graph);
        this.setCirclesDraggable(true);
        this.setLinesBendable(true);
        this.setVisible(true);
    }

    public Circle getCircle(V v) {
        return this.nodes.get(v);
    }

    public void setCircleStringToDrawFunc(Function<Circle, String> f) {
        if (f == null) {
            throw new IllegalArgumentException("f cannot be null");
        }
        this.circleStringToDrawFunc = f;
    }

    public void setLineStringToDrawFunc(Function<Line, String> f) {
        if (f == null) {
            throw new IllegalArgumentException("f cannot be null");
        }
        this.lineStringToDrawFunc = f;
    }

    public void setLineStrokeFunc(Function<Line, Stroke> f) {
        if (f == null) {
            throw new IllegalArgumentException("f cannot be null");
        }
        this.lineStrokeFunc = f;
    }

    public void setCirclesDraggable(boolean draggable) {
        if (draggable) {
            Function<Circle, MouseListener> clickListenerProvider = c -> new MouseListener((Circle)c){
                final /* synthetic */ Circle val$c;
                {
                    this.val$c = circle;
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.val$c.maxX = GraphPanel.this.getWidth();
                    this.val$c.maxY = GraphPanel.this.getHeight();
                    this.val$c.clickPoint = e.getPoint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            };
            Function<Circle, MouseMotionListener> motionListenerProvider = c -> new MouseMotionListener((Circle)c){
                final /* synthetic */ Circle val$c;
                {
                    this.val$c = circle;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    Point p = e.getPoint();
                    int newX = Math.min(this.val$c.maxX, Math.max(0, this.val$c.getX1() + p.x - ((Circle)this.val$c).clickPoint.x));
                    int newY = Math.min(this.val$c.maxY, Math.max(0, this.val$c.getY1() + p.y - ((Circle)this.val$c).clickPoint.y));
                    this.val$c.setX1(newX);
                    this.val$c.setY1(newY);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                }
            };
            for (Circle c2 : this.nodes.values()) {
                c2.moveListener = clickListenerProvider.apply(c2);
                c2.addMouseListener(c2.moveListener);
                c2.moveMotionListener = motionListenerProvider.apply(c2);
                c2.addMouseMotionListener(c2.moveMotionListener);
            }
        } else {
            for (Circle c3 : this.nodes.values()) {
                c3.removeMouseListener(c3.moveListener);
                c3.moveListener = null;
                c3.removeMouseMotionListener(c3.moveMotionListener);
                c3.moveMotionListener = null;
            }
        }
    }

    public void addCircleMouseListener(MouseListener mouseListener) {
        for (Circle c : this.nodes.values()) {
            c.addMouseListener(mouseListener);
        }
    }

    public void removeCicleMouseListener(MouseListener mouseListener) {
        for (Circle c : this.nodes.values()) {
            c.removeMouseListener(mouseListener);
        }
    }

    public void setLinesBendable(boolean bendable) {
        if (bendable) {
            Function<Line, MouseListener> clickListenerProvider = l -> new MouseListener((Line)l){
                final /* synthetic */ Line val$l;
                {
                    this.val$l = line;
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.val$l.clickPoint = e.getPoint();
                    this.val$l.maxX = GraphPanel.this.getWidth();
                    this.val$l.maxY = GraphPanel.this.getHeight();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.val$l.clickPoint = null;
                    this.val$l.cachedCenterXLoc = this.val$l.centerXLoc;
                    this.val$l.cachedCenterYLoc = this.val$l.centerYLoc;
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            };
            Function<Line, MouseMotionListener> motionListenerProvider = l -> new MouseMotionListener((Line)l){
                final /* synthetic */ Line val$l;
                {
                    this.val$l = line;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (this.val$l.clickPoint != null) {
                        Point p = e.getPoint();
                        int newX = Math.min(this.val$l.maxX, Math.max(0, this.val$l.getXMid() + p.x - ((Line)this.val$l).clickPoint.x));
                        int newY = Math.min(this.val$l.maxY, Math.max(0, this.val$l.getYMid() + p.y - ((Line)this.val$l).clickPoint.y));
                        this.val$l.centerXLoc = (float)(newX - this.val$l.getXMin()) / (float)(this.val$l.getXMax() - this.val$l.getXMin());
                        this.val$l.centerYLoc = (float)(newY - this.val$l.getYMin()) / (float)(this.val$l.getYMax() - this.val$l.getYMin());
                        this.val$l.fixBounds();
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                }
            };
            for (Line l2 : this.edges.values()) {
                l2.bendListener = clickListenerProvider.apply(l2);
                l2.addMouseListener(l2.bendListener);
                l2.bendMotionListener = motionListenerProvider.apply(l2);
                l2.addMouseMotionListener(l2.bendMotionListener);
            }
        } else {
            for (Line l3 : this.edges.values()) {
                l3.removeMouseListener(l3.bendListener);
                l3.bendListener = null;
                l3.removeMouseMotionListener(l3.bendMotionListener);
                l3.bendMotionListener = null;
            }
        }
    }

    private void addGraph(Graph<V, E> graph) {
        this.nodes.clear();
        this.edges.clear();
        int i = 0;
        for (V v : graph.vertexSet()) {
            this.nodes.put((Circle)v, new Circle(v, 100 + i++ * 50, (int)(Math.random() * 100.0) + 50, 25));
            this.add(this.nodes.get(v));
        }
        for (Object e : graph.edgeSet()) {
            Graph.Edge edge = graph.getEdge(e);
            Circle c1 = this.nodes.get(((Graph.Vertex)edge._1).v);
            Circle c2 = this.nodes.get(((Graph.Vertex)edge._3).v);
            Line l = new Line(c1, c2, graph.getEdge(e));
            this.edges.put(e, l);
            c1.lines.add(l);
            c2.lines.add(l);
            this.add(this.edges.get(e));
        }
    }

    public static void main(String[] args) {
        Graph<String, Integer> g = new Graph<String, Integer>();
        g.addVertex("A");
        g.addVertex("B");
        g.addVertex("C");
        g.addVertex("D");
        g.addEdge("A", "C", 1);
        g.addEdge("B", "C", 2);
        g.addEdge("C", "D", 3);
        GraphPanel gp = new GraphPanel(g);
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(gp, "Center");
        jFrame.pack();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }

    public static <V, E> void showGraph(Graph<V, E> g) {
        new GraphPanel<V, E>(g);
    }

    public class Line
    extends JPanel {
        private static final long serialVersionUID = -1688624827819736589L;
        public static final int LINE_THICKNESS = 2;
        public static final int PADDING = 5;
        public final Color DEFAULT_COLOR = Color.DARK_GRAY;
        private Circle c1;
        private Circle c2;
        private float centerXLoc = 0.5f;
        private float centerYLoc = 0.5f;
        private float cachedCenterXLoc = this.centerXLoc;
        private float cachedCenterYLoc = this.centerXLoc;
        boolean arrowEnd1;
        boolean arrowEnd2;
        private Point clickPoint;
        private int maxX;
        private int maxY;
        private Color color;
        private Graph.Edge represents;
        private MouseListener bendListener;
        private MouseMotionListener bendMotionListener;
        public static final int ON_LINE_TOLERANCE = 20;
        private static final double ARROW_LENGTH = 12.0;
        private static final double ARROW_ANGLE = 0.5235987755982988;

        public Line(Circle c1, Circle c2, Graph.Edge r) {
            this.setC1(c1);
            this.setC2(c2);
            this.represents = r;
            this.fixBounds();
            this.setOpaque(false);
        }

        public Circle getC1() {
            return this.c1;
        }

        protected void setC1(Circle c) {
            this.c1 = c;
        }

        public Circle getC2() {
            return this.c2;
        }

        protected void setC2(Circle c) {
            this.c2 = c;
        }

        public E getRepresents() {
            return this.represents._2;
        }

        public int getX1() {
            return this.c1.getX1();
        }

        public int getY1() {
            return this.c1.getY1();
        }

        public int getX2() {
            return this.c2.getX1();
        }

        public int getY2() {
            return this.c2.getY1();
        }

        public int getXMin() {
            return Math.min(this.c1.getX1(), this.c2.getX1());
        }

        public int getXMax() {
            return Math.max(this.c1.getX1(), this.c2.getX1());
        }

        public int getYMin() {
            return Math.min(this.c1.getY1(), this.c2.getY1());
        }

        public int getYMax() {
            return Math.max(this.c1.getY1(), this.c2.getY1());
        }

        public Point getMid() {
            return new Point(this.getXMid(), this.getYMid());
        }

        public int getXMid() {
            return this.getXMin() + (int)((float)(this.getXMax() - this.getXMin()) * this.cachedCenterXLoc);
        }

        public int getYMid() {
            return this.getYMin() + (int)((float)(this.getYMax() - this.getYMin()) * this.cachedCenterYLoc);
        }

        private void fixBounds() {
            int minX = Math.min(this.getXMin(), this.getXMid()) - 5;
            int maxX = Math.max(this.getXMax(), this.getXMid()) + 5;
            int minY = Math.min(this.getYMin(), this.getYMid()) - 5;
            int maxY = Math.max(this.getYMax(), this.getYMid()) + 5;
            this.setBounds(minX, minY, maxX - minX, maxY - minY);
            this.repaint();
        }

        public Color getColor() {
            return this.color;
        }

        public boolean isOnLine(Point p) {
            double dist = this.distanceTo(p);
            return dist <= 20.0;
        }

        public double distanceTo(Point p) {
            return Line2D.ptLineDist(this.c1.getX1(), this.c1.getY1(), this.c2.getX1(), this.c2.getY1(), p.getX(), p.getY());
        }

        public boolean intersects(Line l) {
            return !this.c1.locationEquals(l.getC1()) && !this.c1.locationEquals(l.getC2()) && !this.c2.locationEquals(l.getC1()) && !this.c2.locationEquals(l.getC2()) && Line2D.linesIntersect(this.c1.getX1(), this.c1.getY1(), this.c2.getX1(), this.c2.getY1(), l.getX1(), l.getY1(), l.getX2(), l.getY2());
        }

        @Override
        public String toString() {
            return "(" + this.c1.getX1() + "," + this.c1.getY1() + "), (" + this.c2.getX1() + "," + this.c2.getY1() + ")";
        }

        private double getAngle(double x1, double x2, double y1, double y2) {
            double diffX = x2 - x1;
            double diffY = y2 - y1;
            double hypotenuse = Math.sqrt(diffX * diffX + diffY * diffY);
            double angle = Math.acos(diffX / hypotenuse);
            if (y2 < y1) {
                angle = Math.PI * 2 - angle;
            }
            return angle;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setStroke(new BasicStroke(2.0f));
            double angle1 = this.getAngle(this.getX1(), this.getX2(), this.getY1(), this.getY2());
            double y1 = (double)this.getY1() + Math.sin(angle1) * (double)this.c1.diameter / 2.0 + 1.0 - (double)this.getYMin() + 5.0;
            double x1 = (double)this.getX1() + Math.cos(angle1) * (double)this.c1.diameter / 2.0 + 1.0 - (double)this.getXMin() + 5.0;
            double y3 = (double)this.getY2() - Math.sin(angle1) * (double)this.c2.diameter / 2.0 - (double)this.getYMin() + 5.0;
            double x3 = (double)this.getX2() - Math.cos(angle1) * (double)this.c2.diameter / 2.0 - (double)this.getXMin() + 5.0;
            double x2 = (x1 + x3) * (double)this.centerXLoc;
            double y2 = (y1 + y3) * (double)this.centerYLoc;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(x1, y1);
            generalPath.curveTo(x1, y1, x2, y2, x3, y3);
            g2d.setStroke((Stroke)GraphPanel.this.lineStrokeFunc.apply(this));
            g2d.setColor(this.getColor());
            g2d.draw(generalPath);
            if (GraphPanel.this.directed) {
                double angle2 = this.getAngle(x2, x3, y2, y3);
                Polygon arrow = new Polygon();
                arrow.addPoint((int)x3, (int)y3);
                arrow.addPoint((int)(x3 + 12.0 * Math.cos(angle2 + Math.PI - 0.5235987755982988)), (int)(y3 + 12.0 * Math.sin(angle2 + Math.PI - 0.5235987755982988)));
                arrow.addPoint((int)(x3 + 12.0 * Math.cos(angle2 + Math.PI + 0.5235987755982988)), (int)(y3 + 12.0 * Math.sin(angle2 + Math.PI + 0.5235987755982988)));
                g2d.fill(arrow);
            }
            g2d.drawString((String)GraphPanel.this.lineStringToDrawFunc.apply(this), this.getXMid(), this.getYMid() - 10);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(Math.abs(this.getX2() - this.getX1()), Math.abs(this.getY2() - this.getY1()));
        }
    }

    public class Circle
    extends JPanel {
        private static final long serialVersionUID = 1250263410666963976L;
        public static final int DEFAULT_DIAMETER = 25;
        public static final int PANEL_BUFFER = 12;
        public static final int BUFFER_RADUIS = 125;
        private V represents;
        private int x1;
        private int y1;
        private int diameter;
        private Color color;
        private boolean filled;
        private HashSet<Line> lines;
        private Point clickPoint;
        private int maxX;
        private int maxY;
        private MouseListener moveListener;
        private MouseMotionListener moveMotionListener;
        private static final int LINE_THICKNESS = 2;
        private static final int TEXT_HEIGHT = 15;
        private static final int TEXT_WIDTH = 25;

        public Circle(V v, int x, int y, int d) {
            this(v, x, y, d, null, false);
        }

        public Circle(V r, int x, int y, int d, Color c, boolean filled) {
            this.represents = r;
            this.lines = new HashSet();
            this.setBounds(0, 0, 37, 37);
            this.setDiameter(d);
            this.setX1(x);
            this.setY1(y);
            this.color = c != null ? c : Color.black;
            this.filled = filled;
            this.setOpaque(false);
        }

        public int getX1() {
            return this.x1;
        }

        public void setX1(int x) {
            this.x1 = x;
            this.fixBounds();
            for (Line l : this.lines) {
                l.fixBounds();
            }
        }

        public int getY1() {
            return this.y1;
        }

        public void setY1(int y) {
            this.y1 = y;
            this.fixBounds();
            for (Line l : this.lines) {
                l.fixBounds();
            }
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color c) {
            this.color = c;
        }

        public int getDiameter() {
            return this.diameter;
        }

        protected void setDiameter(int d) {
            this.diameter = d;
            this.fixBounds();
        }

        public V getRepresents() {
            return this.represents;
        }

        private void fixBounds() {
            int x = this.getX1();
            int y = this.getY1();
            int d = this.getDiameter();
            int dP = d + 12;
            this.setBounds(x - dP / 2, y - dP / 2, dP, dP);
            Rectangle oldBounds = this.getBounds();
            this.setBounds(oldBounds.x, oldBounds.y - 15, oldBounds.width + 25, oldBounds.height + 15);
            this.repaint();
        }

        protected void switchLocation(Circle c) {
            int x2 = c.getX1();
            int y2 = c.getY1();
            c.setX1(this.x1);
            c.setY1(this.y1);
            this.setX1(x2);
            this.setY1(y2);
        }

        public double getDistance(Circle c) {
            return Math.sqrt(Math.pow(this.x1 - c.getX1(), 2.0) + Math.pow(this.y1 - c.getY1(), 2.0));
        }

        public boolean locationEquals(Circle c) {
            return this.x1 == c.x1 && this.y1 == c.y1;
        }

        @Override
        public String toString() {
            return "(" + (this.getX1() - this.getDiameter() / 2) + "," + (this.getY1() - this.getDiameter() / 2) + ") , d=" + this.getDiameter() + " " + (String)GraphPanel.this.circleStringToDrawFunc.apply(this);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int heightPlus = 15;
            Ellipse2D.Double circle2d = new Ellipse2D.Double(6.0, 6 + heightPlus, this.getDiameter(), this.getDiameter());
            g2d.setColor(this.getColor());
            if (this.filled) {
                g2d.fill(circle2d);
            }
            g2d.draw(circle2d);
            g2d.setFont(STRING_FONT);
            g2d.drawString((String)GraphPanel.this.circleStringToDrawFunc.apply(this), 12, 12);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.getDiameter(), this.getDiameter());
        }
    }
}

