/*
 * Decompiled with CFR 0.152.
 */
package graph;

import common.Util;
import common.dataStructures.ConsList;
import common.dataStructures.NotInCollectionException;
import common.dataStructures.UnionFind;
import common.types.Tuple2;
import graph.Copyable;
import graph.Flowable;
import graph.Graph;
import graph.Weighted;
import graph.matching.Agent;
import graph.matching.Endowed;
import graph.matching.Matching;
import graph.matching.StrictAgent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Algorithm {
    private Algorithm() {
    }

    public static <V, E extends Weighted> int sumPathWeight(Graph<V, E> g, LinkedList<V> path) throws NotInCollectionException {
        if (path == null || path.size() < 2) {
            return 0;
        }
        int s = 0;
        Iterator one = path.iterator();
        Iterator two = path.iterator();
        two.next();
        while (two.hasNext()) {
            Object v2;
            Object v1 = one.next();
            Weighted e = (Weighted)g.getConnection(v1, v2 = two.next());
            if (e == null) {
                throw new NotInCollectionException("Can't get cost of " + v1 + " to " + v2 + " edge is null", new Object[0]);
            }
            s += e.getWeight();
        }
        return s;
    }

    public static <V, E extends Copyable<E>> Graph<V, E> makeDirectedGraph(Graph<V, E> g) {
        if (g.isDirected()) {
            return g.clone();
        }
        Graph<V, Copyable> g2 = new Graph<V, Copyable>(true);
        g.vertexSet().forEach(g2::addVertex);
        for (Copyable e : g.edgeSet()) {
            if (g.isSelfEdge(e)) {
                g2.addEdge(g.sourceOf(e), g.sinkOf(e), e);
                continue;
            }
            g2.addEdge(g.sourceOf(e), g.sinkOf(e), e);
            Copyable e2 = (Copyable)e.copy();
            g2.addEdge(g.sinkOf(e), g.sourceOf(e), e2);
        }
        return g2;
    }

    public static <V, E extends Weighted> LinkedList<V> dijkstra(Graph<V, E> g, V start, V goal) throws NotInCollectionException, RuntimeException {
        if (!g.containsVertex((Weighted)start) || !g.containsVertex((Weighted)goal)) {
            throw new NotInCollectionException("Can't tun dijkstra's algorithm", start, goal);
        }
        for (Weighted e : g.edgeSet()) {
            if (e.getWeight() > 0) continue;
            throw new RuntimeException("Can't run dijkstra's algorithm on graph with non-positive weights");
        }
        HashMap distance = new HashMap();
        Comparator distanceComparator = (o1, o2) -> (Integer)distance.get(o1) - (Integer)distance.get(o2);
        HashMap previous = new HashMap();
        for (V v : g.vertexSet()) {
            distance.put(v, Integer.MAX_VALUE);
            previous.put(v, null);
        }
        distance.put(start, 0);
        HashSet<V> frontier = new HashSet<V>();
        frontier.add(start);
        do {
            Object next = Collections.min(frontier, distanceComparator);
            frontier.remove(next);
            if (next.equals(goal)) break;
            for (Weighted e : g.edgeSetOfSource((Weighted)next)) {
                V neighbor = g.getOther(e, (Weighted)next);
                if ((Integer)distance.get(neighbor) <= (Integer)distance.get(next) + e.getWeight()) continue;
                distance.put(neighbor, (Integer)distance.get(next) + e.getWeight());
                previous.put(neighbor, next);
                if (frontier.contains(neighbor)) continue;
                frontier.add(neighbor);
            }
        } while (!frontier.isEmpty());
        if (frontier.isEmpty() && ((Integer)distance.get(goal)).equals(Integer.MAX_VALUE)) {
            return null;
        }
        LinkedList<V> path = new LinkedList<V>();
        V v = goal;
        do {
            path.push(v);
        } while ((v = previous.get(v)) != null);
        return path;
    }

    public static <V, E> List<E> getCycle(Graph<V, E> g) {
        if (g.edgeSize() == 0) {
            return null;
        }
        for (E e : g.edgeSet()) {
            if (!g.isSelfEdge(e)) continue;
            ArrayList<E> lst = new ArrayList<E>();
            lst.add(e);
            return lst;
        }
        if (g.isDirected()) {
            HashSet visited = new HashSet();
            HashMap<V, E> prev = new HashMap<V, E>();
            ArrayList<V> toTry = new ArrayList<V>(g.vertexSet());
            while (!toTry.isEmpty()) {
                LinkedList<V> queue = new LinkedList<V>();
                queue.add(Util.randomElement(toTry));
                while (!queue.isEmpty()) {
                    V next;
                    Object current = queue.poll();
                    if (visited.contains(current)) {
                        LinkedList cycle = new LinkedList();
                        current = g.getOther(prev.get(current), current);
                        Object edge = prev.get(current);
                        next = g.sourceOf(edge);
                        while (!cycle.contains(edge)) {
                            cycle.push(edge);
                            edge = prev.get(next);
                            next = g.sourceOf(edge);
                        }
                        return cycle;
                    }
                    visited.add(current);
                    for (E travel : g.edgeSetOfSource(current)) {
                        next = g.sinkOf(travel);
                        queue.add(next);
                        prev.put(next, travel);
                    }
                }
                toTry.removeAll(visited);
                visited.clear();
                prev.clear();
            }
            return null;
        }
        UnionFind<V> uf = new UnionFind<V>(g.vertexSet());
        for (E e : g.edgeSet()) {
            V v1 = g.sourceOf(e);
            V v2 = g.sinkOf(e);
            if (uf.find(v1).equals(uf.find(v2))) {
                return Algorithm.getCycleHelper(g, v1, v1, new ConsList());
            }
            uf.union(v1, v2);
        }
        return null;
    }

    private static <V, E> List<E> getCycleHelper(Graph<V, E> g, V start, V current, ConsList<E> path) {
        if (start == current && path.size() != 0) {
            ArrayList<E> lst = new ArrayList<E>();
            for (E e : path.reverse()) {
                lst.add(e);
            }
            return lst;
        }
        for (E e : g.edgeSetOfSource(current)) {
            List<E> cycle;
            if (path.contains(e) || (cycle = Algorithm.getCycleHelper(g, start, g.getOther(e, current), path.cons(e))) == null) continue;
            return cycle;
        }
        return null;
    }

    public static <V, E> boolean isDAG(Graph<V, E> g) {
        if (!g.isDirected()) {
            return false;
        }
        Object g2 = g.clone();
        Comparator minDegreeComparator = (arg_0, arg_1) -> Algorithm.lambda$isDAG$1((Graph)g2, arg_0, arg_1);
        ArrayList arrLst = new ArrayList();
        arrLst.addAll(((Graph)g2).vertexSet());
        while (((Graph)g2).vertexSize() > 0) {
            Object minV = Collections.min(arrLst, minDegreeComparator);
            if (((Graph)g2).inDegreeOf(minV) > 0) {
                return false;
            }
            arrLst.remove(minV);
            ((Graph)g2).removeVertex(minV);
        }
        return true;
    }

    public static <V, E> boolean isBipartite(Graph<V, E> g) {
        HashSet sideA = new HashSet();
        HashSet<V> sideB = new HashSet<V>();
        HashSet<V> allVertices = new HashSet<V>(g.vertexSet());
        LinkedList<V> queue = new LinkedList<V>();
        while (!allVertices.isEmpty()) {
            queue.clear();
            sideA.clear();
            sideB.clear();
            queue.add(Util.randomElement(allVertices));
            sideA.add(queue.getFirst());
            while (!queue.isEmpty()) {
                HashSet<V> otherSide;
                HashSet side;
                Object v = queue.poll();
                allVertices.remove(v);
                if (sideA.contains(v)) {
                    side = sideA;
                    otherSide = sideB;
                } else {
                    side = sideB;
                    otherSide = sideA;
                }
                for (V neighbor : g.neighborsOf(v)) {
                    if (side.contains(neighbor)) {
                        return false;
                    }
                    if (otherSide.contains(neighbor)) continue;
                    queue.addFirst(neighbor);
                    otherSide.add(neighbor);
                }
            }
        }
        return true;
    }

    public static <V, E extends Flowable> Flow<E> maxFlow(Graph<V, E> g, V source, V sink) throws IllegalArgumentException {
        if (source == null || sink == null || source.equals(sink)) {
            throw new IllegalArgumentException("Source and Sink must be non-null and distinct");
        }
        if (!g.isDirected()) {
            throw new IllegalArgumentException("Can only compute maxflow on directed graphs");
        }
        return ((MaxFlow)new MaxFlow<V, E>(g, source, sink)).computeMaxFlow();
    }

    public static <A extends StrictAgent<I>, I> Matching<A, I> serialDictator(Set<A> agents, Set<I> items) {
        ArrayList<A> ordering = new ArrayList<A>(agents);
        Collections.shuffle(ordering);
        return Algorithm.serialDictator(ordering, items);
    }

    public static <A extends StrictAgent<I>, I> Matching<A, I> serialDictator(List<A> agents, Set<I> items) throws IllegalArgumentException {
        HashSet<A> agentsSet = new HashSet<A>(agents);
        if (agents.size() != agentsSet.size()) {
            throw new IllegalArgumentException("Can't use ordering " + agents + " over agents " + agentsSet);
        }
        Matching<A, Object> matching = new Matching<A, Object>();
        matching.addAllA(agents);
        matching.addAllB(items);
        block0: for (StrictAgent agent : agents) {
            for (Object item : agent.getRankPreferences()) {
                if (!matching.isUnmatched(item)) continue;
                matching.match(agent, item);
                continue block0;
            }
        }
        return matching;
    }

    public static <A extends StrictAgent<I> & Endowed<I>, I> Matching<A, I> ttc(Set<A> agents) throws RuntimeException {
        Matching matching = new Matching();
        HashMap reverseInitialEndowment = new HashMap();
        matching.addAllA(agents);
        Graph<Object, Object> g = new Graph<Object, Object>();
        for (Object agent : agents) {
            g.addVertex(agent);
            matching.addB(((Endowed)agent).getInitialEndowment());
            reverseInitialEndowment.put(((Endowed)agent).getInitialEndowment(), agent);
        }
        HashMap<Object, Integer> currentPreference = new HashMap<Object, Integer>();
        for (Object agent : agents) {
            for (int i = 0; i < agent.getRankPreferences().length; ++i) {
                if (!matching.contains(agent.getRankPreferences()[i])) continue;
                currentPreference.put(agent, i);
                g.addEdge(agent, reverseInitialEndowment.get(agent.getRankPreferences()[i]), new Object());
                break;
            }
            if (currentPreference.containsKey(agent)) continue;
            throw new RuntimeException("Can't run ttc on " + agents + "," + agent + " doesn't like any item");
        }
        while (g.vertexSize() > 0) {
            List cycle;
            while ((cycle = Algorithm.getCycle(g)) != null) {
                for (Object edge : cycle) {
                    StrictAgent taker = (StrictAgent)g.sourceOf(edge);
                    StrictAgent giver = (StrictAgent)g.sinkOf(edge);
                    matching.match(taker, ((Endowed)((Object)giver)).getInitialEndowment());
                }
                for (Object edge : cycle) {
                    g.removeVertex(g.sourceOf(edge));
                    g.removeVertex(g.sinkOf(edge));
                }
            }
            for (Object agent : agents) {
                if (matching.isMatched(agent)) continue;
                boolean foundItem = false;
                for (int i = ((Integer)currentPreference.get(agent)).intValue(); i < agent.getRankPreferences().length; ++i) {
                    Object pref = agent.getRankPreferences()[i];
                    if (matching.isMatched(pref)) continue;
                    currentPreference.put(agent, i);
                    g.addEdge(agent, reverseInitialEndowment.get(pref), new Object());
                    foundItem = true;
                    break;
                }
                if (foundItem) continue;
                throw new RuntimeException("Can't run ttc on " + agents + "," + agent + " doesn't like any item");
            }
        }
        return matching;
    }

    public static <A extends StrictAgent<B>, B extends StrictAgent<A>> Matching<A, B> stableMarriage(Set<A> proposers, Set<B> proposees) {
        Matching<StrictAgent, StrictAgent> matching = new Matching<StrictAgent, StrictAgent>(proposers, proposees);
        HashMap<StrictAgent, Integer> lowestProposal = new HashMap<StrictAgent, Integer>();
        HashMap<StrictAgent, Boolean> doneProposing = new HashMap<StrictAgent, Boolean>();
        for (StrictAgent a : proposers) {
            lowestProposal.put(a, -1);
            doneProposing.put(a, false);
        }
        block1: while (true) {
            Set<A> unmatchedProposers = matching.getUnmatchedA();
            boolean unmatchedAreHappier = true;
            for (StrictAgent a : unmatchedProposers) {
                unmatchedAreHappier = unmatchedAreHappier && (Boolean)doneProposing.get(a) != false;
            }
            if (unmatchedAreHappier) {
                return matching;
            }
            Iterator<A> iterator = unmatchedProposers.iterator();
            while (true) {
                StrictAgent b;
                StrictAgent a;
                if (!iterator.hasNext()) continue block1;
                a = (StrictAgent)iterator.next();
                int nextProposal = (Integer)lowestProposal.get(a);
                boolean proposing = true;
                do {
                    if (++nextProposal != ((StrictAgent[])a.getRankPreferences()).length) continue;
                    proposing = false;
                    doneProposing.put(a, true);
                } while (proposing && !proposees.contains(((StrictAgent[])a.getRankPreferences())[nextProposal]));
                if (!proposing || (!matching.isUnmatched(b = ((StrictAgent[])a.getRankPreferences())[nextProposal]) || !Agent.isAcceptable(b, a)) && !Agent.prefers(b, a, matching.getMatchedA(b))) continue;
                matching.match(a, b);
            }
            break;
        }
    }

    private static /* synthetic */ int lambda$isDAG$1(Graph graph, Object o1, Object o2) {
        return graph.inDegreeOf(o1) - graph.inDegreeOf(o2);
    }

    private static class MaxFlow<V, E extends Flowable> {
        private HashMap<V, Integer> label;
        private HashMap<E, Integer> flow;
        private HashMap<V, Integer> excess;
        private final V source;
        private final V sink;
        private final Graph<V, E> g;
        private final Flow<E> flowObj;

        public MaxFlow(Graph<V, E> g, V source, V sink) {
            boolean opOccured;
            this.g = g;
            this.source = source;
            this.sink = sink;
            this.label = new HashMap();
            this.excess = new HashMap();
            this.flow = new HashMap();
            for (V v : g.vertexSet()) {
                this.label.put((Integer)v, 0);
                this.excess.put((Integer)v, 0);
                for (V v2 : g.vertexSet()) {
                    Flowable e = (Flowable)g.getConnection(v, v2);
                    if (e == null) continue;
                    this.flow.put(e, 0);
                }
            }
            this.label.put((Integer)source, g.vertexSize());
            for (Flowable e : g.edgeSetOfSource(source)) {
                if (g.isSelfEdge(e)) continue;
                V edgeEnd = g.getOther(e, source);
                this.excess.put((Integer)source, this.excess.get(source) - e.getCapacity());
                this.excess.put((Integer)edgeEnd, this.excess.get(edgeEnd) + e.getCapacity());
                this.flow.put(e, e.getCapacity());
            }
            do {
                opOccured = false;
                for (V v : g.vertexSet()) {
                    for (Flowable e : g.edgeSetOfSource(v)) {
                        opOccured = this.push(v, e, true) | opOccured;
                    }
                    for (Flowable e : g.edgeSetOfSink(v)) {
                        opOccured = this.push(v, e, false) | opOccured;
                    }
                    if (opOccured) continue;
                    opOccured = this.relabel(v);
                }
            } while (opOccured);
            this.flowObj = new Flow<E>(this.excess.get(sink), this.flow);
        }

        private boolean push(V u, E e, boolean forward) {
            V v = this.g.getOther(e, u);
            if (this.excess.get(u) <= 0 || this.label.get(u) != this.label.get(v) + 1) {
                return false;
            }
            int mult = forward ? 1 : -1;
            int delta = Math.min(this.excess.get(u), e.getCapacity() - this.flow.get(e));
            this.flow.put(e, this.flow.get(e) + mult * delta);
            this.excess.put((Integer)u, this.excess.get(u) - mult * delta);
            this.excess.put((Integer)v, this.excess.get(v) + mult * delta);
            return delta != 0;
        }

        private boolean relabel(V u) {
            if (this.excess.get(u) <= 0 || u == this.source || u == this.sink) {
                return false;
            }
            int minVal = Integer.MAX_VALUE;
            for (V v : this.g.vertexSet()) {
                Flowable e = (Flowable)this.g.getConnection(u, v);
                if (e == null || this.flow.get(e) >= e.getCapacity()) continue;
                if (this.label.get(u) > this.label.get(v)) {
                    return false;
                }
                minVal = Math.min(minVal, this.label.get(v));
            }
            if (minVal == Integer.MAX_VALUE) {
                return false;
            }
            int oldVal = this.label.get(u);
            this.label.put((Integer)u, minVal + 1);
            return oldVal != minVal + 1;
        }

        private Flow<E> computeMaxFlow() {
            return this.flowObj;
        }
    }

    public static class Flow<E>
    extends Tuple2<Integer, HashMap<E, Integer>> {
        public Flow(Integer first, HashMap<E, Integer> second) {
            super(first, second);
        }
    }
}

