/*
 * Decompiled with CFR 0.152.
 */
package functional;

import functional.BiPredicate;
import functional.Predicate;
import functional.Supplier;
import functional.TriConsumer;
import functional.TriFuncShell;
import java.util.Objects;

@FunctionalInterface
public interface TriPredicate<A, B, C>
extends TriFuncShell<A, B, C> {
    public boolean apply(A var1, B var2, C var3);

    default public boolean test(A a, B b, C c) {
        return this.apply(a, b, c);
    }

    @Override
    default public BiPredicate<B, C> partialApply(A a) {
        return (b, c) -> this.apply(a, b, c);
    }

    @Override
    default public BiPredicate<B, C> lazyApply(Supplier<A> aSupplier) {
        return (b, c) -> this.apply(aSupplier.apply(), b, c);
    }

    @Override
    default public Predicate<C> partialApply(A a, B b) {
        return this.partialApply((Object)a).partialApply(b);
    }

    @Override
    default public Supplier<Boolean> partialApply(A a, B b, C c) {
        return this.partialApply((Object)a).partialApply(b).partialApply(c);
    }

    @Override
    default public Predicate<C> partialLazyApply(Supplier<A> aSupplier, B b) {
        return this.lazyApply((Supplier)aSupplier).partialApply(b);
    }

    @Override
    default public Predicate<C> partialLazyApply(A a, Supplier<B> bSupplier) {
        return this.partialApply((Object)a).lazyApply(bSupplier);
    }

    @Override
    default public Supplier<Boolean> partialLazyApply(Supplier<A> aSupplier, B b, C c) {
        return this.lazyApply((Supplier)aSupplier).partialApply(b).partialApply(c);
    }

    @Override
    default public Supplier<Boolean> partialLazyApply(A a, Supplier<B> bSupplier, C c) {
        return this.partialApply((Object)a).lazyApply(bSupplier).partialApply(c);
    }

    @Override
    default public Supplier<Boolean> partialLazyApply(A a, B b, Supplier<C> cSupplier) {
        return this.partialApply((Object)a).partialApply(b).lazyApply(cSupplier);
    }

    @Override
    default public Supplier<Boolean> partialLazyApply(Supplier<A> aSupplier, Supplier<B> bSupplier, C c) {
        return this.lazyApply((Supplier)aSupplier).lazyApply(bSupplier).partialApply(c);
    }

    @Override
    default public Supplier<Boolean> partialLazyApply(A a, Supplier<B> bSupplier, Supplier<C> cSupplier) {
        return this.partialApply((Object)a).lazyApply(bSupplier).lazyApply(cSupplier);
    }

    @Override
    default public Supplier<Boolean> partialLazyApply(Supplier<A> aSupplier, B b, Supplier<C> cSupplier) {
        return this.lazyApply((Supplier)aSupplier).partialApply(b).lazyApply(cSupplier);
    }

    @Override
    default public Predicate<C> lazyApply(Supplier<A> aSupplier, Supplier<B> bSupplier) {
        return this.lazyApply((Supplier)aSupplier).lazyApply(bSupplier);
    }

    @Override
    default public Supplier<Boolean> lazyApply(Supplier<A> aSupplier, Supplier<B> bSupplier, Supplier<C> cSupplier) {
        return this.lazyApply((Supplier)aSupplier).lazyApply(bSupplier).lazyApply(cSupplier);
    }

    @Override
    default public TriConsumer<A, B, C> discardReturn() {
        return (a, b, c) -> this.apply(a, b, c);
    }

    default public TriPredicate<C, A, B> rotate() {
        return (c, a, b) -> this.apply(a, b, c);
    }

    default public TriPredicate<A, B, C> negate() {
        return (a, b, c) -> !this.apply(a, b, c);
    }

    default public TriPredicate<A, B, C> and(TriPredicate<A, B, C> other) {
        Objects.requireNonNull(other);
        return (a, b, c) -> this.apply(a, b, c) && other.apply(a, b, c);
    }

    default public TriPredicate<A, B, C> or(TriPredicate<A, B, C> other) {
        Objects.requireNonNull(other);
        return (a, b, c) -> this.apply(a, b, c) || other.apply(a, b, c);
    }

    default public TriPredicate<A, B, C> nand(TriPredicate<A, B, C> other) {
        Objects.requireNonNull(other);
        return (a, b, c) -> !this.apply(a, b, c) || !other.apply(a, b, c);
    }

    default public TriPredicate<A, B, C> nor(TriPredicate<A, B, C> other) {
        Objects.requireNonNull(other);
        return (a, b, c) -> !this.apply(a, b, c) && !other.apply(a, b, c);
    }

    default public TriPredicate<A, B, C> xor(TriPredicate<A, B, C> other) {
        Objects.requireNonNull(other);
        return (a, b, c) -> this.apply(a, b, c) ^ other.apply(a, b, c);
    }

    default public TriPredicate<A, B, C> xnor(TriPredicate<A, B, C> other) {
        Objects.requireNonNull(other);
        return (a, b, c) -> !(this.apply(a, b, c) ^ other.apply(a, b, c));
    }
}

