/*
 * Decompiled with CFR 0.152.
 */
package functional;

import common.dataStructures.DeArrList;
import functional.BiConsumer;
import functional.BiFunction;
import functional.BiPredicate;
import functional.Consumer;
import functional.Function;
import functional.Predicate;
import functional.Supplier;
import functional.TriFunction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class FunctionalUtil {
    public static <A> Consumer<A> migrate(java.util.function.Consumer<A> consumer) {
        return consumer::accept;
    }

    public static <A> Supplier<A> migrate(java.util.function.Supplier<A> supplier) {
        return supplier::get;
    }

    public static <A> Predicate<A> migrate(java.util.function.Predicate<A> predicate) {
        return predicate::test;
    }

    public static <A, R> Function<A, R> migrate(java.util.function.Function<A, R> function) {
        return function::apply;
    }

    public static <A, B> BiConsumer<A, B> migrate(java.util.function.BiConsumer<A, B> biConsumer) {
        return biConsumer::accept;
    }

    public static <A, B> BiPredicate<A, B> migrate(java.util.function.BiPredicate<A, B> biPredicate) {
        return biPredicate::test;
    }

    public static <A, B, R> BiFunction<A, B, R> migrate(java.util.function.BiFunction<A, B, R> biFunction) {
        return biFunction::apply;
    }

    public static void forEach(int[] arr, Consumer<Integer> f) {
        for (int i = 0; i < arr.length; ++i) {
            f.apply(arr[i]);
        }
    }

    public static void forEach(double[] arr, Consumer<Double> f) {
        for (int i = 0; i < arr.length; ++i) {
            f.apply(arr[i]);
        }
    }

    public static void forEach(long[] arr, Consumer<Long> f) {
        for (int i = 0; i < arr.length; ++i) {
            f.apply(arr[i]);
        }
    }

    public static <T> void forEach(T[] arr, Consumer<T> f) {
        for (int i = 0; i < arr.length; ++i) {
            f.apply(arr[i]);
        }
    }

    public static <T> void forEach(Iterable<T> col, Consumer<T> f) {
        for (T t : col) {
            f.apply(t);
        }
    }

    public static <T, S> List<S> map(T[] arr, Function<T, S> f) {
        DeArrList<S> lst = new DeArrList<S>();
        for (T t : arr) {
            lst.add(f.apply(t));
        }
        return lst;
    }

    public static <T, S> List<S> map(Iterable<T> col, Function<T, S> f) {
        DeArrList<S> lst = new DeArrList<S>();
        for (T t : col) {
            lst.add(f.apply(t));
        }
        return lst;
    }

    public static <T, R> R foldLeft(R start, T[] arr, BiFunction<R, T, R> f) {
        return FunctionalUtil.foldLeft(start, Arrays.asList(arr), f);
    }

    public static <T, R> R foldLeft(R start, Iterable<T> col, BiFunction<R, T, R> f) {
        for (T t : col) {
            start = f.apply(start, t);
        }
        return start;
    }

    public static <T, S, R> R foldLeft2(R start, T[] arr, S[] arr2, TriFunction<R, T, S, R> f) {
        int min = Math.min(arr.length, arr2.length);
        for (int i = 0; i < min; ++i) {
            start = f.apply(start, arr[i], arr2[i]);
        }
        return start;
    }

    public static <T, S, R> R foldLeft2(R start, Iterable<T> col, Iterable<S> col2, TriFunction<R, T, S, R> f) {
        Iterator<T> c = col.iterator();
        Iterator<S> c2 = col2.iterator();
        while (c.hasNext() && c2.hasNext()) {
            start = f.apply(start, c.next(), c2.next());
        }
        return start;
    }

    public static <T> List<T> filter(T[] col, Predicate<T> f) {
        return FunctionalUtil.filter(Arrays.asList(col), f);
    }

    public static <T> List<T> filter(Iterable<T> col, Predicate<T> f) {
        DeArrList<T> lst = new DeArrList<T>();
        for (T t : col) {
            if (!f.apply(t)) continue;
            lst.add(t);
        }
        return lst;
    }

    private FunctionalUtil() {
    }
}

