/*
 * Decompiled with CFR 0.152.
 */
package concurrent;

import functional.Supplier;

public class MethodRunner<T> {
    private final Supplier<T> methodCall;
    private T result;
    private boolean done;
    private final long millisToWait;
    private static final long MILLIS_SLEEP_BETWEEN_UPDATES = 100L;

    public MethodRunner(Supplier<T> methodCall, long millisToWait) throws IllegalArgumentException {
        if (methodCall == null) {
            throw new IllegalArgumentException("Can't create timeout worker on null method call");
        }
        if (millisToWait <= 0L) {
            throw new IllegalArgumentException("Can't wait a non-positive number of milliseconds");
        }
        this.methodCall = methodCall;
        this.millisToWait = millisToWait;
    }

    public T runAndGet() {
        this.done = false;
        this.result = null;
        long startTime = System.currentTimeMillis();
        TimeoutWorker r = new TimeoutWorker();
        r.start();
        while (System.currentTimeMillis() < startTime + this.millisToWait && !this.done) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        if (!this.done) {
            r.stop();
        }
        this.done = true;
        return this.result;
    }

    public T get() {
        if (this.done) {
            return this.result;
        }
        return this.runAndGet();
    }

    private class TimeoutWorker
    extends Thread {
        private TimeoutWorker() {
        }

        @Override
        public void run() {
            MethodRunner.this.result = MethodRunner.this.methodCall.apply();
            MethodRunner.this.done = true;
        }

        @Override
        public String toString() {
            return "Timeout worker for " + this;
        }
    }
}

