/*
 * Decompiled with CFR 0.152.
 */
package common.math;

import common.math.Vector;

public class Vector3
extends Vector {
    public Vector3(double x, double y, double z) {
        super(x, y, z);
    }

    public Vector3() {
        this(0.0, 0.0, 0.0);
    }

    public double x() {
        return this.get(0);
    }

    public double y() {
        return this.get(1);
    }

    public double z() {
        return this.get(2);
    }

    @Override
    public Vector3 invert() {
        return new Vector3(-this.x(), -this.y(), -this.z());
    }

    public Vector3 add(Vector3 other) {
        return new Vector3(this.x() + other.x(), this.y() + other.y(), this.z() + other.z());
    }

    public Vector3 subtract(Vector3 other) {
        return this.add(other.invert());
    }

    public double dot(Vector3 other) {
        return this.x() * other.x() + this.y() * other.y() + this.z() * other.z();
    }

    public Vector3 cross(Vector3 other) {
        return new Vector3(this.y() * other.z() - this.z() * other.y(), this.z() * other.x() - this.x() * other.z(), this.x() * other.y() - this.y() * other.x());
    }

    public double angle(Vector3 other) {
        return Math.atan2(this.cross(other).magnitude(), this.dot(other));
    }
}

