/*
 * Decompiled with CFR 0.152.
 */
package common.math;

import common.math.Vector;
import common.math.Vector3;
import common.types.Tuple;
import common.types.Tuple2;

public class Vector2
extends Vector {
    public Vector2(double x, double y) {
        super(x, y);
    }

    public Vector2() {
        this(0.0, 0.0);
    }

    public static Vector2 fromPolarCoordinates(double r, double theta) {
        return new Vector2(r * Math.cos(theta), r * Math.sin(theta));
    }

    public double x() {
        return this.get(0);
    }

    public double y() {
        return this.get(1);
    }

    public Tuple2<Double, Double> toPolarCoordinates() {
        return Tuple.of(this.magnitude(), Math.atan2(this.y(), this.x()));
    }

    public Vector2 rotate(double theta) {
        Tuple2<Double, Double> p = this.toPolarCoordinates();
        return Vector2.fromPolarCoordinates((Double)p._1, (Double)p._2 + theta);
    }

    @Override
    public Vector2 invert() {
        return new Vector2(-this.x(), -this.y());
    }

    public Vector2 add(Vector2 other) {
        return new Vector2(this.x() + other.x(), this.y() + other.y());
    }

    public Vector2 subtract(Vector2 other) {
        return this.add(other.invert());
    }

    public double dot(Vector2 other) {
        return this.x() * other.x() + this.y() * other.y();
    }

    public double angle(Vector2 other) {
        return Math.acos(this.dot(other) / (this.magnitude() * other.magnitude()));
    }

    public double cross(Vector2 other) {
        return new Vector3(this.x(), this.y(), 0.0).cross(new Vector3(other.x(), other.y(), 0.0)).z();
    }
}

