/*
 * Decompiled with CFR 0.152.
 */
package common.math;

import common.Util;
import functional.FunctionalUtil;
import java.util.Arrays;
import java.util.Iterator;

public class Vector
implements Iterable<Double> {
    private Double[] vec;
    private double magnitude;

    private Double[] longerVec(Vector v1, Vector v2) {
        Object[] v = new Double[Math.max(v1.dimension(), v2.dimension())];
        Arrays.fill(v, (Object)0);
        return v;
    }

    public Vector() {
        this.vec = new Double[0];
        this.magnitude = -1.0;
    }

    public Vector(double[] components) {
        this(Util.boxArr(components));
    }

    public Vector(Double ... components) {
        this.vec = Arrays.copyOf(components, components.length);
        this.magnitude = -1.0;
    }

    public Vector(Vector ... components) {
        this(components[0].vec);
        for (int i = 1; i < components.length; ++i) {
            this.add(components[i]);
        }
    }

    public Vector add(Vector other) {
        int n;
        Double[] doubleArray;
        int i;
        Vector v = new Vector(this.longerVec(this, other));
        for (i = 0; i < this.dimension(); ++i) {
            doubleArray = v.vec;
            n = i;
            Double.valueOf(doubleArray[n] + this.vec[i]);
        }
        for (i = 0; i < other.dimension(); ++i) {
            doubleArray = v.vec;
            n = i;
            Double.valueOf(doubleArray[n] + other.vec[i]);
        }
        return v;
    }

    public Vector add(Double ... vec) {
        return this.add(new Vector(vec));
    }

    public Vector invert() {
        Vector v = new Vector(this.vec);
        for (int i = 0; i < v.dimension(); ++i) {
            v.vec[i] = -1.0 * v.vec[i];
        }
        return v;
    }

    public Vector subtract(Vector other) {
        return this.add(other.invert());
    }

    public Vector scale(double k) {
        Vector v = new Vector(this.vec);
        int i = 0;
        while (i < v.dimension()) {
            Double[] doubleArray = v.vec;
            int n = i++;
            Double.valueOf(doubleArray[n] * k);
        }
        return v;
    }

    public double dot(Vector other) {
        return FunctionalUtil.foldLeft2(Double.valueOf(0.0), this.vec, other.vec, (a, b, c) -> a + b * c);
    }

    public final Double[] get() {
        return Arrays.copyOf(this.vec, this.vec.length);
    }

    public final Double get(int index) {
        return this.vec[index];
    }

    public double magnitude() {
        if (this.magnitude >= 0.0) {
            return this.magnitude;
        }
        this.magnitude = Math.sqrt(FunctionalUtil.foldLeft(Double.valueOf(0.0), this.vec, (a, b) -> a + b * b));
        return this.magnitude;
    }

    public final int dimension() {
        return this.vec.length;
    }

    public String toString() {
        if (this.dimension() == 0) {
            return "<>";
        }
        String s = "<";
        for (int i = 0; i < this.dimension() - 1; ++i) {
            s = s + this.vec[i] + ", ";
        }
        return s + this.vec[this.dimension() - 1] + ">";
    }

    public int hashCode() {
        return Arrays.hashCode((Object[])this.vec);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vector)) {
            return false;
        }
        return Arrays.equals((Object[])this.vec, (Object[])((Vector)o).vec);
    }

    @Override
    public Iterator<Double> iterator() {
        return new VectorIterator();
    }

    class VectorIterator
    implements Iterator<Double> {
        private int index = 0;

        VectorIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < Vector.this.dimension();
        }

        @Override
        public Double next() {
            return Vector.this.get(this.index++);
        }
    }
}

