/*
 * Decompiled with CFR 0.152.
 */
package common.dataStructures;

import common.dataStructures.util.ViewSet;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LinkedHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Iterable<Map.Entry<K, V>> {
    private HashMap<K, LinkedHashEntry> map;
    private LinkedHashEntry head;
    private LinkedHashEntry tail;
    protected int modCount;
    private KeySet keySet;
    private ValueCollection values;
    private EntrySet entrySet;
    private static final int DEFAULT_SIZE = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public LinkedHashMap() {
        this(16, 0.75f);
    }

    public LinkedHashMap(int initalCapacity, float loadFactor) {
        this.map = new HashMap(initalCapacity, loadFactor);
        this.keySet = new KeySet();
        this.values = new ValueCollection();
        this.entrySet = new EntrySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (V v : this.values()) {
            if (!Objects.equals(v, value)) continue;
            return true;
        }
        return false;
    }

    private LinkedHashEntry getEntry(K key) {
        return this.map.get(key);
    }

    public Map.Entry<K, V> get(int index) throws IllegalArgumentException {
        if (index < 0 || index >= this.size()) {
            throw new IllegalArgumentException(index + " is OOB for " + this);
        }
        LinkedHashEntry current = null;
        if (index < this.size() / 2) {
            current = this.head;
            while (index > 0) {
                current = current.next;
                --index;
            }
        } else {
            current = this.tail;
            for (index = this.size() - 1 - index; index > 0; --index) {
                current = current.prev;
            }
        }
        return current;
    }

    @Override
    public V get(Object key) {
        if (!this.map.containsKey(key)) {
            return null;
        }
        return (V)this.map.get(key).val;
    }

    public Map.Entry<K, V> getFirst() {
        return this.head;
    }

    public Map.Entry<K, V> getLast() {
        return this.tail;
    }

    public int indexOf(Object o) {
        LinkedHashEntry current = this.head;
        int i = 0;
        while (current != null) {
            if (Objects.equals(current, o) || Objects.equals(current.key, o) || Objects.equals(current.val, o)) {
                return i;
            }
            current = current.next;
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        LinkedHashEntry current = this.tail;
        int i = 0;
        while (current != null) {
            if (Objects.equals(current, o) || Objects.equals(current.key, o) || Objects.equals(current.val, o)) {
                return i;
            }
            current = current.prev;
            ++i;
        }
        return -1;
    }

    private V putHelper(K key, V value, int index) {
        if (index < 0 || index > this.size()) {
            throw new IllegalArgumentException("Can't put;" + index + " is OOB for " + this);
        }
        if (this.containsKey(key)) {
            Object oldVal = this.getEntry(key).val;
            this.getEntry(key).val = value;
            return (V)oldVal;
        }
        LinkedHashEntry e = new LinkedHashEntry(key, value);
        if (this.size() == 0) {
            this.head = e;
            this.tail = e;
        } else if (index == this.size()) {
            this.tail.next = e;
            e.prev = this.tail;
            this.tail = e;
        } else if (index == 0) {
            this.head.prev = e;
            e.next = this.head;
            this.head = e;
        } else {
            LinkedHashEntry e2 = (LinkedHashEntry)this.get(index);
            LinkedHashEntry e2P = e2.prev;
            e2P.next = e;
            e2.prev = e;
            e.prev = e2P;
            e.next = e2;
        }
        this.map.put(key, e);
        ++this.modCount;
        return null;
    }

    @Override
    public V put(K key, V value) {
        return this.putHelper(key, value, this.size());
    }

    public V putLast(K key, V value) {
        return this.putAt(key, value, this.size());
    }

    public V putFirst(K key, V value) {
        return this.putAt(key, value, 0);
    }

    public V putAt(K key, V value, int index) {
        if (this.containsKey(key)) {
            throw new RuntimeException("Can't call putAt on an already existing key");
        }
        return this.putHelper(key, value, index);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("Can't put all of an unordered Map");
    }

    public boolean add(Map.Entry<K, V> e) {
        if (this.containsKey(e.getKey())) {
            return false;
        }
        this.putLast(e.getKey(), e.getValue());
        return true;
    }

    public boolean add(int index, Map.Entry<K, V> element) {
        if (this.containsKey(element.getKey())) {
            return false;
        }
        this.putAt(element.getKey(), element.getValue(), index);
        return true;
    }

    public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
        boolean altered = false;
        for (Map.Entry<K, V> e : c) {
            altered = this.add(e) || altered;
        }
        return altered;
    }

    public boolean addAll(int index, Collection<? extends Map.Entry<K, V>> c) {
        boolean altered = false;
        for (Map.Entry<K, V> e : c) {
            altered = this.add(index, e) || altered;
            ++index;
        }
        return altered;
    }

    public Map.Entry<K, V> set(int index, Map.Entry<K, V> element) {
        if (this.containsKey(element.getKey())) {
            throw new IllegalArgumentException("Can't call set with already present key " + element.getKey());
        }
        LinkedHashEntry old = (LinkedHashEntry)this.get(index);
        LinkedHashEntry oldCopy = new LinkedHashEntry(old.key, old.val);
        old.key = element.getKey();
        old.val = element.getValue();
        return oldCopy;
    }

    @Override
    public V remove(Object key) {
        LinkedHashEntry entry = this.map.get(key);
        if (entry == null) {
            return null;
        }
        LinkedHashEntry e0 = entry.prev;
        LinkedHashEntry e1 = entry.next;
        if (e0 != null) {
            e0.next = e1;
        }
        if (e1 != null) {
            e1.prev = e0;
        }
        if (entry == this.head) {
            this.head = e1;
        }
        if (entry == this.tail) {
            this.tail = e0;
        }
        this.map.remove(key);
        ++this.modCount;
        return (V)entry.val;
    }

    public Map.Entry<K, V> remove(int index) {
        Map.Entry<K, V> e = this.get(index);
        this.remove(e.getKey());
        return e;
    }

    public boolean removeAll(Collection<?> c) {
        boolean altered = false;
        for (Object o : c) {
            altered = this.remove(o) != null || altered;
        }
        return altered;
    }

    public boolean retainAll(Collection<?> c) {
        Iterator iter = this.keySet.iterator();
        boolean altered = false;
        while (iter.hasNext()) {
            Object k = iter.next();
            if (c.contains(k)) continue;
            iter.remove();
            altered = true;
        }
        return altered;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.head = null;
        this.tail = null;
    }

    @Override
    public Set<K> keySet() {
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.entrySet.iterator();
    }

    public Object[] toArray() {
        Object[] o = new Object[this.size()];
        int i = 0;
        Iterator<Map.Entry<K, V>> iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> e;
            o[i] = e = iterator.next();
            ++i;
        }
        return o;
    }

    public <T> T[] toArray(T[] a) throws ClassCastException {
        T[] arr = a.length >= this.size() ? a : Arrays.copyOf(a, this.size());
        int i = 0;
        for (Map.Entry<K, V> e : this) {
            arr[i] = e;
            ++i;
        }
        return arr;
    }

    private class EntrySet
    extends ViewSet<Map.Entry<K, V>> {
        public EntrySet() {
            super(LinkedHashMap.this);
        }

        @Override
        public boolean remove(Object o) {
            try {
                return LinkedHashMap.this.remove(((Map.Entry)o).getKey()) != null;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new HashIterator<Map.Entry<K, V>>(){

                @Override
                protected Map.Entry<K, V> valFromEntry(Map.Entry<K, V> e) {
                    return e;
                }
            };
        }
    }

    private class ValueCollection
    extends ViewSet<V> {
        public ValueCollection() {
            super(LinkedHashMap.this);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Can't remove from a values collection - may have multiple mappings");
        }

        @Override
        public Iterator<V> iterator() {
            return new HashIterator<V>(){

                @Override
                protected V valFromEntry(Map.Entry<K, V> e) {
                    return e.getValue();
                }
            };
        }
    }

    private class KeySet
    extends ViewSet<K> {
        public KeySet() {
            super(LinkedHashMap.this);
        }

        @Override
        public boolean remove(Object o) {
            return LinkedHashMap.this.remove(o) != null;
        }

        @Override
        public Iterator<K> iterator() {
            return new HashIterator<K>(){

                @Override
                protected K valFromEntry(Map.Entry<K, V> e) {
                    return e.getKey();
                }
            };
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        private int expectedModCount;
        private boolean removed = false;
        private LinkedHashEntry current;

        public HashIterator() {
            this.expectedModCount = LinkedHashMap.this.modCount;
            this.current = LinkedHashMap.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        protected abstract E valFromEntry(Map.Entry<K, V> var1);

        @Override
        public E next() {
            if (this.expectedModCount != LinkedHashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            LinkedHashEntry e = this.current;
            this.removed = false;
            this.current = this.current.next;
            return this.valFromEntry(e);
        }

        @Override
        public void remove() {
            if (this.removed) {
                return;
            }
            LinkedHashMap.this.remove(this.current.key);
            ++this.expectedModCount;
            this.removed = true;
        }
    }

    private class LinkedHashEntry
    implements Map.Entry<K, V> {
        private K key;
        private V val;
        private LinkedHashEntry next;
        private LinkedHashEntry prev;

        private LinkedHashEntry(K k, V v) throws IllegalArgumentException {
            if (k == null) {
                throw new IllegalArgumentException("Null keys not allowed");
            }
            this.key = k;
            this.val = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        @Override
        public V setValue(V value) {
            Object oldVal = this.val;
            this.val = value;
            return oldVal;
        }

        @Override
        public boolean equals(Object o) {
            try {
                LinkedHashEntry e = (LinkedHashEntry)o;
                return this.key.equals(e.key) && Objects.equals(this.val, e.val);
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.key, this.val);
        }

        public String toString() {
            return this.key + "=" + this.val;
        }
    }
}

