/*
 * Decompiled with CFR 0.152.
 */
package common.dataStructures;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

public class ConsList<E>
implements Iterable<E> {
    public static final String NIL_STRING = "_NIL_";
    private final ConsList<E> tail;
    public final E val;
    public final int size;

    public ConsList() {
        this.val = null;
        this.tail = null;
        this.size = 0;
    }

    private ConsList(E val, ConsList<E> tail, int size) {
        this.val = val;
        this.size = size;
        this.tail = tail;
        if (val == null || tail == null || size < 1) {
            throw new RuntimeException("Illegal ConsList construction" + this);
        }
    }

    public E value() {
        return this.val;
    }

    public ConsList<E> tail() {
        return this.tail;
    }

    public boolean isNil() {
        return this.tail() == null && this.val == null;
    }

    public boolean isLast() {
        return this.isNil() || this.tail().tail() == null && this.tail().val == null;
    }

    public ConsList<E> cons(E head) {
        return new ConsList<E>(head, this, this.size + 1);
    }

    public ConsList<E> reverse() {
        ConsList<E> reversed = new ConsList<E>();
        ConsList<E> ptr = this;
        while (!ptr.isNil()) {
            reversed = reversed.cons(ptr.val);
            ptr = ptr.tail;
        }
        return reversed;
    }

    public String toString() {
        String s = "(";
        for (ConsList<E> current = this; current != null; current = current.tail()) {
            if (current.val == null && current.tail() == null) {
                if (current != this) continue;
                s = s + "_NIL_,";
                continue;
            }
            s = s + current.val + ",";
        }
        return s.substring(0, s.length() - 1) + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConsList) || o == null) {
            return false;
        }
        ConsList lst = (ConsList)o;
        return this.size == lst.size && Objects.equals(this.val, lst.val) && Objects.equals(this.tail(), lst.tail());
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object o) {
        return !this.isNil() && (Objects.equals(this.val, o) || !this.isLast() && this.tail().contains(o));
    }

    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new ConsIterator(this);
    }

    public Object[] toArray() {
        Object[] arr = new Object[this.size];
        ConsList<E> current = this;
        int i = 0;
        while (i < this.size) {
            arr[i] = current.val;
            ++i;
            current = current.tail();
        }
        return arr;
    }

    public <T> T[] toArray(T[] arr) {
        if (arr.length < this.size) {
            arr = Arrays.copyOf(arr, this.size);
        }
        ConsList<E> current = this;
        int i = 0;
        while (i < this.size) {
            arr[i] = current.val;
            ++i;
            current = current.tail();
        }
        return arr;
    }

    public E get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Can't get element at index " + index + " OOB");
        }
        if (index == 0) {
            return this.val;
        }
        return this.tail().get(index - 1);
    }

    public int indexOf(Object o) {
        return this.indexOf(o, 0);
    }

    private int indexOf(Object o, int x) {
        if (Objects.equals(this.val, o)) {
            return x;
        }
        if (this.isLast()) {
            return -1;
        }
        return super.indexOf(o, x + 1);
    }

    public static class ConsIterator<E>
    implements Iterator<E> {
        private ConsList<E> current;

        public ConsIterator(ConsList<E> first) {
            this.current = first;
        }

        @Override
        public boolean hasNext() {
            return !this.current.isNil();
        }

        @Override
        public E next() {
            Object val = this.current.val;
            this.current = this.current.tail();
            return val;
        }
    }
}

