/*
 * Decompiled with CFR 0.152.
 */
package common;

import functional.Consumer;
import functional.FunctionalUtil;
import functional.TriConsumer;
import functional.Unit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.Assert;

public class JUnitUtil {
    private JUnitUtil() {
    }

    public static Unit failFunc() {
        return Assert::fail;
    }

    public static Unit failFunc(String message) {
        Consumer<String> f = Assert::fail;
        return f.partialApply((Object)message);
    }

    public static Unit assertTrueFunc(boolean condition) {
        Consumer<Boolean> f = Assert::assertTrue;
        return f.partialApply((Object)condition);
    }

    public static Unit assertTrueFunc(String message, boolean condition) {
        functional.BiConsumer<String, Boolean> f = Assert::assertTrue;
        return f.partialApply((Object)message, (Object)condition);
    }

    public static Unit assertFalseFunc(boolean condition) {
        Consumer<Boolean> f = Assert::assertFalse;
        return f.partialApply((Object)condition);
    }

    public static Unit assertFalseFunc(String message, boolean condition) {
        functional.BiConsumer<String, Boolean> f = Assert::assertFalse;
        return f.partialApply((Object)message, (Object)condition);
    }

    public static Unit assertEqualsFunc(Object expected, Object actual) {
        functional.BiConsumer<Object, Object> f = Assert::assertEquals;
        return f.partialApply(expected, actual);
    }

    public static Unit assertEqualsFunc(String message, Object expected, Object actual) {
        TriConsumer<String, Object, Object> f = Assert::assertEquals;
        return f.partialApply((Object)message, expected, actual);
    }

    public static void callAndAssetTrue(functional.Supplier<Boolean> conditionSupplier) {
        Assert.assertTrue((boolean)conditionSupplier.apply());
    }

    public static void callAndAssetTrue(String message, functional.Supplier<Boolean> conditionSupplier) {
        Assert.assertTrue((String)message, (boolean)conditionSupplier.apply());
    }

    public static void callAndAssetFalse(functional.Supplier<Boolean> conditionSupplier) {
        Assert.assertFalse((boolean)conditionSupplier.apply());
    }

    public static void callAndAssetFalse(String message, functional.Supplier<Boolean> conditionSupplier) {
        Assert.assertFalse((String)message, (boolean)conditionSupplier.apply());
    }

    public static void callAndAssertEquals(Object expected, functional.Supplier<Object> actualSupplier) {
        Assert.assertEquals((Object)expected, (Object)actualSupplier.apply());
    }

    public static void callAndAssertEquals(functional.Supplier<Object> expectedSupplier, functional.Supplier<Object> actualSupplier) {
        Assert.assertEquals((Object)expectedSupplier.apply(), (Object)actualSupplier.apply());
    }

    public static void callAndAssertEquals(String message, Object expected, functional.Supplier<Object> actualSupplier) {
        Assert.assertEquals((String)message, (Object)expected, (Object)actualSupplier.apply());
    }

    public static void callAndAssertEquals(String message, functional.Supplier<Object> expectedSupplier, functional.Supplier<Object> actualSupplier) {
        Assert.assertEquals((String)message, (Object)expectedSupplier.apply(), (Object)actualSupplier.apply());
    }

    public static Unit callAndAssertTrueFunc(functional.Supplier<Boolean> conditionSupplier) {
        Consumer<Boolean> f = Assert::assertTrue;
        return f.lazyApply((functional.Supplier)conditionSupplier);
    }

    public static Unit callAndAssertTrueFunc(String message, functional.Supplier<Boolean> conditionSupplier) {
        functional.BiConsumer<String, Boolean> f = Assert::assertTrue;
        return f.partialLazyApply((Object)message, conditionSupplier);
    }

    public static Unit callAndAssertFalseFunc(functional.Supplier<Boolean> conditionSupplier) {
        Consumer<Boolean> f = Assert::assertFalse;
        return f.lazyApply((functional.Supplier)conditionSupplier);
    }

    public static Unit callAndAssertFalseFunc(String message, functional.Supplier<Boolean> conditionSupplier) {
        functional.BiConsumer<String, Boolean> f = Assert::assertFalse;
        return f.partialLazyApply((Object)message, conditionSupplier);
    }

    public static Unit callAndAssertEqualsFunc(Object expected, functional.Supplier<Object> actualSupplier) {
        functional.BiConsumer<Object, Object> f = Assert::assertEquals;
        return f.partialLazyApply(expected, (functional.Supplier)actualSupplier);
    }

    public static Unit callAndAssertEqualsFunc(functional.Supplier<Object> expectedSupplier, functional.Supplier<Object> actualSupplier) {
        functional.BiConsumer<Object, Object> f = Assert::assertEquals;
        return f.lazyApply((functional.Supplier)expectedSupplier, (functional.Supplier)actualSupplier);
    }

    public static Unit callAndAssertEqualsFunc(String message, Object expected, functional.Supplier<Object> actualSupplier) {
        TriConsumer<String, Object, Object> f = Assert::assertEquals;
        return f.partialLazyApply((Object)message, expected, actualSupplier);
    }

    public static Unit callAndAssertEqualsFunc(String message, functional.Supplier<Object> expectedSupplier, functional.Supplier<Object> actualSupplier) {
        TriConsumer<String, Object, Object> f = Assert::assertEquals;
        return f.partialLazyApply((Object)message, expectedSupplier, actualSupplier);
    }

    public static int testAll(Unit ... assertsToTest) {
        if (assertsToTest == null || assertsToTest.length == 0) {
            return 0;
        }
        int passedCount = 0;
        for (Unit u : assertsToTest) {
            try {
                u.apply();
                ++passedCount;
            }
            catch (AssertionError e) {
                // empty catch block
            }
        }
        return passedCount;
    }

    public static void shouldFail(Unit request) {
        JUnitUtil.shouldFail(request, Throwable.class);
    }

    public static <E extends Throwable> void shouldFail(Unit request, Class<E> expectedException) {
        boolean got = false;
        Exception ex = null;
        try {
            request.apply();
            got = true;
        }
        catch (Exception e) {
            ex = e;
        }
        if (got) {
            Assert.fail((String)"method call did not result in exception");
        }
        if (!expectedException.isAssignableFrom(ex.getClass())) {
            Assert.fail((String)("method call failed, but with exception " + ex + ". Expected " + expectedException));
        }
    }

    public static <T> void shouldFail(Supplier<T> request) {
        JUnitUtil.shouldFail(FunctionalUtil.migrate(request).asUnit());
    }

    public static <T, E extends Throwable> void shouldFail(Supplier<T> request, Class<E> expectedException) {
        JUnitUtil.shouldFail(FunctionalUtil.migrate(request).asUnit(), expectedException);
    }

    public static <T> void shouldFail(java.util.function.Consumer<T> request, T arg) {
        JUnitUtil.shouldFail((Unit)FunctionalUtil.migrate(request).partialApply((Object)arg));
    }

    public static <T, E extends Throwable> void shouldFail(java.util.function.Consumer<T> request, Class<E> expectedException, T arg) {
        JUnitUtil.shouldFail((Unit)FunctionalUtil.migrate(request).partialApply((Object)arg), expectedException);
    }

    public static <T, R> void shouldFail(Function<T, R> request, T arg) {
        JUnitUtil.shouldFail(FunctionalUtil.migrate(request).partialApply((Object)arg).asUnit());
    }

    public static <T, R, E extends Throwable> void shouldFail(Function<T, R> request, Class<E> expectedException, T arg) {
        JUnitUtil.shouldFail(FunctionalUtil.migrate(request).partialApply((Object)arg).asUnit(), expectedException);
    }

    public static <T, R> void shouldFail(BiConsumer<T, R> request, T arg1, R arg2) {
        JUnitUtil.shouldFail(FunctionalUtil.migrate(request).partialApply((Object)arg1, (Object)arg2).asUnit());
    }

    public static <T, R, E extends Throwable> void shouldFail(BiConsumer<T, R> request, Class<E> expectedException, T arg1, R arg2) {
        JUnitUtil.shouldFail(FunctionalUtil.migrate(request).partialApply((Object)arg1, (Object)arg2).asUnit(), expectedException);
    }

    public static <T, R, S> void shouldFail(BiFunction<T, R, S> request, T arg1, R arg2) {
        JUnitUtil.shouldFail(FunctionalUtil.migrate(request).partialApply((Object)arg1, (Object)arg2).asUnit());
    }

    public static <T, R, S, E extends Throwable> void shouldFail(BiFunction<T, R, S> request, Class<E> expectedException, T arg1, R arg2) {
        JUnitUtil.shouldFail(FunctionalUtil.migrate(request).partialApply((Object)arg1, (Object)arg2).asUnit(), expectedException);
    }

    public static <T, R, S> void shouldFail(TriConsumer<T, R, S> request, T arg1, R arg2, S arg3) {
        JUnitUtil.shouldFail(request.partialApply((Object)arg1, (Object)arg2, (Object)arg3).asUnit());
    }

    public static <T, R, S, E extends Throwable> void shouldFail(TriConsumer<T, R, S> request, Class<E> expectedException, T arg1, R arg2, S arg3) {
        JUnitUtil.shouldFail(request.partialApply((Object)arg1, (Object)arg2, (Object)arg3).asUnit(), expectedException);
    }
}

