/** An instance maintains a bounded buffer of limited size */
class BoundedBuffer {
    ArrayQueue<Integer> aq;  // bounded buffer is implemented in aq

    /** Constructor: An empty buffer of max size n */
    public BoundedBuffer(int n) {
        aq= new ArrayQueue<Integer>(n);
    }

    /** Put v into the bounded buffer */
    public synchronized void produce(Integer v) {
        while (aq.isFull())
            try {
                wait();
            } catch (InterruptedException e) {
            }
        aq.put(v);
        notifyAll();
    }
    
    /** Remove first element from bounded buffer and return it. */
    public synchronized Integer consume() {
        while (aq.isEmpty())
            try {
                wait();
            } catch (InterruptedException e) {
            }
        Integer item= aq.get();
        notifyAll();
        return item;
    }
    
}
