/** An instance implements a queue of bounded size in an array */
public class ArrayQueue<E> {
    E[] b; // The n elements of the queue are in
    int n; // b[h], b[(h+1) % n], ... b[(h+n-1) % n]
    int h; // 0 <= h < b.length

    /** Constructor: a queue of maximum size n. */
    public ArrayQueue(int n) {
        b= (E[])new Object[n];
    }
    
    /** Return the size of the queue. */
    public int size() {
        return n;
    }
    
    /** = "queue is empty */
    public boolean isEmpty() {
        return n == 0;
    }
    
    /** = "queue is full */
    public boolean isFull() {
        return n == b.length;
    }

    /** Throw RuntimeExpection if q is full.
     *  Add e to the queue. */
    public void put(E e) {
        if (n == b.length) throw new RuntimeException("queue full");
        b[(h+n) % b.length]= e;
        n= n+1;
    }

    /** Throw a RuntimeException if q is empty.
     *  Return first element of the queue. */
    public E peek() {
        if (n == 0) throw new RuntimeException("queue empty");
        return b[h];
    }

    /** Throw a RuntimeException if the queue is empty.
     *  Take the head of the queue off the queue and return it. */
    public E get() {
        if (n == 0) throw new RuntimeException("queue empty");
        E e= b[h];
        h= (h+1) % b.length;
        n= n-1;
        return e;
    }

}
