import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/* This class demos the use of a function as an argument. This is new in
 * the latest Java.Look at the line containg
 *    eastButton.AddActonListener.
 *    Previous versions of Java forced us to have an argument an object
 *    that contained method actionPerformed. Now, we can just write
 *    a function! that's what we have done. The anonymous function
 *    looks like this:
 *      e -> { 
 *          boolean b= eastButton.isEnabled();
 *          eastButton.setEnabled(!b);
 *          westButton.setEnabled(b);
 *          System.out.println("function called");
 *      }
 *   The function has a parameter e, which is not used.  Its body is
 *   the block beginning with { and ending with }.
 *   
 *   Note that this is syntactic sugar. Before compiling this code,
 *   Java will turn it into an inner class that contains the function
 *   as a method. YOu don't have to worry about how that is done.
 */
public class ButtonDemo4 extends JFrame
implements ActionListener {
    private JButton westButton= new JButton("west");
    private JButton eastButton= new JButton("east");

    /** Show the GUI  */
    public static void main(String[] pars) {
        ButtonDemo4 gui= new ButtonDemo4();
    }

    /** Constructor: inv frame two buttons */
    public ButtonDemo4() {
        super("ButtonDemo4");
        add(westButton,BorderLayout.WEST);
        add(eastButton,BorderLayout.EAST);
        add(new JLabel("   "), BorderLayout.SOUTH);
        add(new JLabel("   "), BorderLayout.CENTER);
        add(new JLabel("   "), BorderLayout.NORTH);
        westButton.setEnabled(false);
        eastButton.setEnabled(true);

        westButton.addActionListener(this);
        eastButton.addActionListener(e -> { 
            boolean b= eastButton.isEnabled();
            eastButton.setEnabled(!b);
            westButton.setEnabled(b);
            System.out.println("function called");
        });

        pack();
        setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        boolean b= eastButton.isEnabled();
        eastButton.setEnabled(!b);
        westButton.setEnabled(b);
        System.out.println("ButtonDemo3 actionPerformed");
    }
}
