import javax.swing.*;
import java.awt.*;
import java.awt.event.*;


public class ButtonDemo3 extends JFrame
    implements ActionListener {
    private JButton westButton= new JButton("west");
    private JButton eastButton= new JButton("east");
    
    /** Show the GUI  */
    public static void main(String[] pars) {
        ButtonDemo3 gui= new ButtonDemo3();
    }
    
    /** Constructor: inv frame two buttons */
    public ButtonDemo3() {
        super("ButtonDemo3");
        add(westButton,BorderLayout.WEST);
        add(eastButton,BorderLayout.EAST);
        add(new JLabel("   "), BorderLayout.SOUTH);
        add(new JLabel("   "), BorderLayout.CENTER);
        add(new JLabel("   "), BorderLayout.NORTH);
        westButton.setEnabled(false);
        eastButton.setEnabled(true);
        
        westButton.addActionListener(this);
        eastButton.addActionListener(this);
        
        
        pack();
        setVisible(true);
    }
    
    public void actionPerformed(ActionEvent e) {
        boolean b= eastButton.isEnabled();
        eastButton.setEnabled(!b);
        westButton.setEnabled(b);
        System.out.println("ButtonDemo3 actionPerformed");
    }
    
}


/** Step 1. Take the comment delimiters away from this class
  to show that it won't compile because the class doesn't
  have access to eastButton and westButton. After trying to compile,
  put comment delimiters back.
  class BeListener implements ActionListener {
  public void actionPerformed(ActionEvent e) {
  boolean b= eastButton.isEnabled();
  eastButton.setEnabled(!b);
  westButton.setEnabled(b);
  }
  }
  */

/** Step 2. Put this private class inside the class,
     as an inner class. Then change
        
        eastButton.addActionListener(this);
     to 
        eastButton.addActionListener(new BeListener());
        
private class BeListener implements ActionListener {
  public void actionPerformed(ActionEvent e) {
  boolean b= eastButton.isEnabled();
  eastButton.setEnabled(!b);
  westButton.setEnabled(b);
  }
  }
  */

/** Step 3. The following code adds an ActionListener to the eastButton using
  * an anonymous class. Go ahead and put it in after the other add-listener
  * statement for the eastButton. Note that the button will then call two
  * different actionPerformed methods, and the east button will stay enabled.
  * Until you comment out the first add-listener statement for the east button.
eastButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                boolean b= eastButton.isEnabled();
                eastButton.setEnabled(!b);
                westButton.setEnabled(b);
                System.out.println("anonymous class actionPerformed");
            }});
*/



