import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/** This class is used to demonstrate having different listeners for
    different buttons. Button westButton has the main class, BUttonDemo2, as
    its listener. Button eastButton has a private inner class, BEListener,
    as its listener.
    
    An instance has the same functionality as an instance of class
    ButtonDemo1.
  */
public class ButtonDemo2 extends JFrame implements ActionListener {
 // Class invariant: exactly one of eastButton and westButton is enabled
 private JButton westButton= new JButton("west");
 private JButton eastButton= new JButton("east");
 
    /** Show the GUI  */
    public static void main(String[] pars) {
        ButtonDemo2 gui= new ButtonDemo2();
    }

 
 /** Constructor: a frame with  two buttons */
 public ButtonDemo2() {
  super("ButtonDemo2");

  add(westButton,BorderLayout.WEST);
  add(eastButton,BorderLayout.EAST);
      
  westButton.setEnabled(false);
  eastButton.setEnabled(true);
 
  westButton.addActionListener(this);
  eastButton.addActionListener(new BeListener());
 
  pack();
  setVisible(true);
 }
        
 /** Process a click of a button */
 public void actionPerformed(ActionEvent e) {
  if (eastButton == e.getSource()) {
   System.out.println("eastButton");
  }
  boolean b= eastButton.isEnabled();
  eastButton.setEnabled(!b);
  westButton.setEnabled(b);
 }
 
 private class BeListener implements ActionListener {
  // Process a click of a button
  public void actionPerformed(ActionEvent e) {
   boolean b= eastButton.isEnabled();
   eastButton.setEnabled(!b);
   westButton.setEnabled(b);
  }
 }
 
}
