/**
 * A collection of operations on trees, written as static methods.
 */
public class StringTreeOps {
    /**
     * Get the number of nodes in a tree.
     *
     * NB: Sometimes, we refer to a node and the tree rooted at the node
     * interchangeably. Technically, here we're getting the number of nodes in
     * the tree rooted at a given node.
     */
    public static int size(StringTreeNode tree) {
        if (tree == null) {
            return 0;
        }
        return size(tree.left) + size(tree.right) + 1;
    }

    /**
     * Check whether any node in the tree has the value v.
     */
    public static boolean contains(StringTreeNode tree, String v) {
        if (tree == null) {
            return false;
        }
        if (tree.value.equals(v)) {
            return true;
        }
        return contains(tree.left, v) || contains(tree.right, v);
    }

    /**
     * Get the length of the longest path from the given node to a leaf or, if
     * tree is empty, return -1.
     */
    public static int height(StringTreeNode tree) {
        if (tree == null) {
            return -1;
        }
        int leftHeight= tree.left.height();
        int rightHeight= tree.right.height();
        if (leftHeight > rightHeight) {
            return leftHeight + 1;
        } else {
            return rightHeight + 1;
        }
    }
}
