/**
 * A binary tree node with a string value.
 */
public class StringTreeNode {
    public String value;
    public StringTreeNode left;
    public StringTreeNode right;

    /**
     * Constructor: make a one-node tree with a given value.
     */
    public StringTreeNode(String v) {
        value= v;

        // Start with no children.
        left= null;
        right= null;
    }

    /**
     * Constructor: a tree with a given value and children.
     */
    public StringTreeNode(String v, StringTreeNode l, StringTreeNode r) {
        this(v);
        left= l;
        right= r;
    }

    /**
     * Get the number of nodes in the tree rooted at this node.
     */
    public int size() {
        int leftSize= left == null ? 0 : left.size();
        int rightSize= right == null ? 0 : right.size();
        return leftSize + rightSize + 1;
    }

    /**
     * Check whether any node in the tree rooted here has the value v.
     */
    public boolean contains(String v) {
        if (value.equals(v)) {
            return true;
        }
        if (left != null && left.contains(v)) {
            return true;
        }
        if (right != null && right.contains(v)) {
            return true;
        }
        return false;
    }

    /**
     * Get the length of the longest path from this node to a leaf.
     */
    public int height() {
        int leftHeight= left == null ? -1 : left.height();
        int rightHeight= right == null ? -1 : right.height();
        if (leftHeight > rightHeight) {
            return leftHeight + 1;
        } else {
            return rightHeight + 1;
        }
    }
}
