public class StringTreeDemo {
    public static void main(String[] args) {
        // Let's make a tree like this:
        //          data
        //           /\
        // structures  have
        //              /\
        //       magical  powers
        StringTreeNode tree = new StringTreeNode(
            "data",
            new StringTreeNode("structures"),
            new StringTreeNode(
                "have",
                new StringTreeNode("magical"),
                new StringTreeNode("powers")
            )
        );

        // Get the tree's height and size.
        System.out.println("Size: " + StringTreeOps.size(tree));
        System.out.println("Height: " + StringTreeOps.height(tree));

        // Search for some values.
        System.out.println("Contains powers: " +
                           StringTreeOps.contains(tree, "powers"));
        System.out.println("Contains 2110: " +
                           StringTreeOps.contains(tree, "2110"));
    }
}
