/**
 * A collection of operations on BSTs, written as static methods.
 */
public class IntBSTOps {
    /**
     * Check whether any node in the tree has the value v.
     */
    public static boolean contains(IntBST tree, int v) {
        if (tree == null) {
            return false;
        }

        // There are three cases: the value is here, or it's "supposed" to be
        // in the left subtree, or it's "supposed" to be in the right subtree.
        if (tree.value == v) {
            return true;
        } else if (v < tree.value) {
            return contains(tree.left, v);
        } else {  // v > tree.value
            return contains(tree.right, v);
        }
    }

    /**
     * Add the value to an appropriate place in the tree, creating a new copy
     * of the tree.
     *
     * Precondition: v is not already in the tree.
     */
    public static IntBST insert(IntBST tree, int v) {
        // If the tree is empty so far, just make a new tree with the value.
        if (tree == null) {
            return new IntBST(v);
        }

        // Check the precondition (which relies on the tree being non-null).
        assert tree.value != v;

        // The node needs to go either in the left subtree or the right
        // subtree.
        if (v < tree.value) {
            // Insert into the left-hand side.
            return new IntBST(tree.value, insert(tree.left, v), tree.right);
        } else {  // v > tree.value
            // Insert into the left-hand side.
            return new IntBST(tree.value, tree.left, insert(tree.right, v));
        }
    }

    /**
     * Get all the values in a tree, in sorted order, and format them into a
     * string.
     */
    public static String inOrder(IntBST tree) {
        if (tree == null) {
            return "";
        }
        return inOrder(tree.left) + " " +
               tree.value + " " +
               inOrder(tree.right);
    }
}
