/**
 * A binary search tree node with an int value.
 *
 * Class invariant: all the values in the left descendants of this node are
 * less than value, and all the values in the right subtree are greater.
 */
public class IntBST {
    public int value;
    public IntBST left;
    public IntBST right;

    /**
     * Constructor: make a one-node tree with a given value.
     */
    public IntBST(int v) {
        value= v;
        left= null;
        right= null;
    }

    /**
     * Constructor: a tree with a given value and children.
     *
     * Precondition: all the values in the subtree rooted at l are less than
     * v. All the values in r are greater than v.
     */
    public IntBST(int v, IntBST l, IntBST r) {
        // Checking this precondition would be expensive, so we just trust
        // callers to do the right thing.
        this(v);
        left= l;
        right= r;
    }
}
