/** This class contains static methods used to 
 * anglicize integers in the range 1..999,999.
 * To "anglicize" means to put into English.
 * Method anglicize contains the solution. 
 * The important point is not the final product but the method of
 * its development, starting with the smaller numbers (as shown below
 * in method anglicize) and interspersing coding with testing. */

public class Ang {
    // conditional expression:  bool-exp ? exp1 : exp2
    /** = English equivalent of n.<br>
    Precondition: 0 < n < 1,000,000.<br><br>
    Examples:                          <br>
    3:      "three"<br>
    45:     "forty five"<br>
    100:    "one hundred"<br>
    127:    "one hundred twenty seven"<br>
    1001:   "one thousand one"<br>
    999099: "nine hundred ninety thousand ninety nine*/
    public static String anglicize(int n) {
        if (n < 20) return ang19[n];
        
        // 20 <= n
        if (n < 100) {
            return tenWords[n/10] + (n%10 == 0 ? "" : " " + ang19[n%10]);
        }
        
        // 100 <= n
        if (n < 1000) {
            return ang19[n/100] + " hundred" + (n%100 == 0 ? "" : " " + anglicize(n%100));
        }
        
        // 1000 <= n
        return anglicize(n/1000) + " thousand" +(n%1000 == 0 ? "" : " " + anglicize(n%1000));
    }
    
    /** The words for all numbers in the range 1..19.
     * The word for i is in ang19[i]. */
    private final static String[] ang19= new String[]{"", "one", "two", "three", "four", "five",
        "six", "seven", "eight", "nine", "ten", "eleven", "twelve",
        "thirteen", "fourteen", "fifteen", "sixteen", "seventeen",
        "eighteen", "nineteen"};

    /** For i in 2..9, tenWords[i] is the "tens word for i, e.g. tenWords[2] is twenty. */
    private final static String[] tenWords= {"", "", "twenty", "thirty", "forty",
        "fifty", "sixty", "seventy", "eighty", "ninety"};
}