import static org.junit.Assert.*;

import java.util.Iterator;

import org.junit.Test;

public class DLinkedListTest {

    @Test
    public void testConstructor() {
        DLinkedList<Integer> b= new DLinkedList<Integer>();
        assertEquals("[]", b.toString());
        assertEquals("[]", b.toStringRev());
        assertEquals(0, b.size());
    }
    


    @Test
    public void testAppend() {
        DLinkedList<String> ll= new DLinkedList<String>(); 
        DLinkedList<String>.Node n= ll.append("Ross"); 
        assertEquals("[Ross]", ll.toString());
        assertEquals("[Ross]", ll.toStringRev());
        assertEquals(1, ll.size());
        assertEquals(ll.getTail(), n); 

        n= ll.append("Gries"); 
        assertEquals("[Ross, Gries]", ll.toString());
        assertEquals("[Gries, Ross]", ll.toStringRev());
        assertEquals(2, ll.size());
        assertEquals(ll.getTail(), n); 
        
        
    }
    
    
    @Test
    public void testAppendStudent() {
        DLinkedList<String> pp= new DLinkedList<String>(); 
        DLinkedList<String>.Node gq= pp.append(""); 
        assertEquals("[]", pp.toString());
        assertEquals("[]", pp.toStringRev());
        assertEquals(1, pp.size());
        assertEquals(pp.getTail(), gq); 

        DLinkedList<String>.Node gqq= pp.append("b"); 
        assertEquals("[b, ]", pp.toStringRev());
        assertEquals("[, b]", pp.toString());
        assertEquals(2, pp.size());
        assertEquals(pp.getTail(), gqq); 

        gqq= pp.append("c"); 
        assertEquals("[c, b, ]", pp.toStringRev());
        assertEquals("[, b, c]", pp.toString());
        assertEquals(3, pp.size());
        assertEquals(pp.getTail(), gqq); 
    }

    @Test
    public void testAdd() {
        DLinkedList<String> ll= new DLinkedList<String>(); 
        boolean n= ll.add("Ross"); 
        assertEquals("[Ross]", ll.toString());
        assertEquals("[Ross]", ll.toStringRev());
        assertEquals(1, ll.size());
        assertEquals(true, n);

        n= ll.add("G"); 
        assertEquals("[Ross, G]", ll.toString());
        assertEquals("[G, Ross]", ll.toStringRev());
        assertEquals(2, ll.size());

        n= ll.add("F"); 
        assertEquals("[Ross, G, F]", ll.toString());
        assertEquals("[F, G, Ross]", ll.toStringRev());
        assertEquals(3, ll.size());
        assertEquals(true, n);
    }

    @Test
    public void testGetNode() {
        DLinkedList<Integer> ll= new DLinkedList<Integer>(); 
        ll.add(1);
        DLinkedList<Integer>.Node n= ll.getNode(0);
        assertEquals(n, ll.getHead());
        
        try {
            DLinkedList<Integer>.Node m= ll.getNode(-1);
            fail();
        } catch (IndexOutOfBoundsException e) {
            
        }

        ll= new DLinkedList<Integer>();
        DLinkedList<Integer>.Node[] b= new DLinkedList.Node[10];
        for (int i= 0; i < b.length; i= i+1) {
            b[i]= ll.append(i);
        }
        for (int i= 0; i < b.length; i= i+1) {
            assertEquals(b[i], ll.getNode(i));
        }
        
        int x= ll.get(5);
        assertEquals(5, x);
        ll.get(5);
    }
    
    @Test
    public void testIterator() {
        DLinkedList<Integer> ll= new DLinkedList<Integer>();
        assertEquals("[]", useIterator(ll));
        
        ll.add(1); ll.add(8); ll.add(7);
        assertEquals("[1, 8, 7]", useIterator(ll));
        

        ll.add(5); ll.add(4); ll.add(3);
        assertEquals("[1, 8, 7, 5, 4, 3]", useIterator(ll));
    }
    
    /** Return the enumeration of ll, with ", " between elements
     * and delimited by "[" and "]", using ll.Iterator */
    public static <E> String useIterator(DLinkedList<E> ll) {
        String res= "[";
        Iterator<E> it= ll.iterator();
        while (it.hasNext()) {
            if (res.length() > 1) {
                res= res + ", ";
            }
            res= res + it.next();
        }
        return res + "]";
    }
    
    @Test
    public void testIterable() {
        DLinkedList<Integer> ll= new DLinkedList<Integer>();
        assertEquals("[]", useForEach(ll));
        
        ll.add(1); ll.add(8); ll.add(7);
        assertEquals("[1, 8, 7]", useForEach(ll));
        

        ll.add(5); ll.add(4); ll.add(3);
        assertEquals("[1, 8, 7, 5, 4, 3]", useForEach(ll));
    }
    
    /** Return the enumeration of ll, with ", " between elements
     * and delimited by "[" and "]", using a foreach statement. */
    public static <E> String useForEach(DLinkedList<E> ll) {
        String res= "[";
        for (E elem : ll) {
            if (res.length() > 1) {
                res= res + ", ";
            }
            res= res + elem;
        }
        return res + "]";
    }

}
