import java.util.Iterator;
import java.util.NoSuchElementException;


/** An instance is a doubly linked list. It provides much of the functionality of
 * Java class java.util.LinkedList. */
public class DLinkedList<E> extends java.util.AbstractList<E> {
    private int size;  // Number of nodes in the linked list.
    private Node head; // first node of the linked list (null if none)
    private Node tail; // last node of the linked list (null if none)

    /** Constructor: an empty linked list. */
    public DLinkedList() {
        // TODO item #1 Nothing to do
    }

    /** Return the head Node of this linked list */
    Node getHead() {// no access modifier. Accessible (only) in package
        return head;
    }

    /** Return the tail Node of this linked list */
    Node getTail() {// no access modifier. Accessible (only) in package
        return tail;
    }

    /** Return the number of elements in this list.
     * This operation must take constant time. */
    public int size() {
        // TODO item #2
        return size;
    }

    /** Return the elements of this list, in order, separated by ", " (comma blank),
     * and delimited by [ and ]. Elements e are turned into Strings using String
     * catenation. Thus, if e is null, the String "null" is automatically used. */
    public String toString() {
        String res= "[";
        Node n= head;
        // invariant: all elements before n (or all if n is null) have been
        //      added to res, with ", " between them and with "[" in the beginning
        while (n != null) {
            if (n != head) res= res + ", ";
            res= res + n.data;
            n= n.succ;
        }
        return res + "]";
    }

    /** Return a representation of this list: its values in reverse order, with
     * adjacent ones separated by ", " (comma blank), with "[" at the beginning,
     * and with "]" at the end. <br/>
     *
     * E.g. for the list containing 6 3 8 in that order, the result is "[8, 3, 6]".
     *
     * To add values to a list, use String catenation as in toString above. */
    public String toStringRev() {
        // TODO item #3
        String end= "[";
        Node t= tail;
        while (t != null){
            if (t != tail) end = end + ", ";
            end = end + t.data;
            t = t.pred;
        }
        return end + "]";
    }

    /** Place element in a new node at the end of the list and return the new node.
     * This operation must take constant time. */
    Node append(E element) {// no access modifier. Accessible (only) in package
        // TODO item #4
        size= size + 1;
        if (size == 1) {
            head= new Node(null,element,null);
            tail= head;
            return head;
        }
        tail.succ= new Node(tail,element,null);
        tail= tail.succ;
        return tail;
    }


    /** Append element to the end of this list and return true. */
    public boolean add(E element) {
        // TODO item #5
        append(element);
        return true;
    }

    /** Return Node number h of this list
     * (the first node is number 0, the second is number 1, etc.)
     * Throw an IndexOutOfBoundsException if h < 0 or h >= size of the list.
     * This method should take time proportional to min(h, size - h). */
    Node getNode(int h) {// no access modifier. Accessible (only) in package
        // TODO item #6
        if (h < 0 || h >= size) throw new IndexOutOfBoundsException();
        if (h <=  size / 2) {
            Node n= head;
            for (int j= 0; j < h; j= j+1){
                n = n.succ;
            }
            return n;
        }
        Node n= tail;
        for (int j= size-1; j > h; j= j-1){
            n = n.pred;
        }
        return n;
    }

    /** Return element number h of this list.
     * (The first element is number 0, the second is number 1, etc.)
     * Throw an IndexOutOfBoundsException if h < 0 or h >= size of the list.
     * The time taken should be proportional to min(h, size - h).*/
    public E get(int h) {
        // TODO item #7
        return getNode(h).data;
    }

    /** Replace element number h of this list by e.
     * (The first element is number 0, the second is number 1, etc.)
     * Return the value that was previously element number h.
     * Throw an IndexOutOfBoundsException if h < 0 or h >= size of the list.
     * The time taken should be proportional to min(h, size - h). */
    public E set(int h, E element) {
        // TODO item #8
        Node n= getNode(h);
        E d= n.data;
        n.data= element;
        return d;
    }

    /** Insert element in a new node at the beginning of the list and
     * return the new node.
     * This operation must take constant time. */
    Node prepend(E element) {// no access modifier. Accessible (only) in package
        // TODO item #9
        size= size + 1;
        if (size == 1){
            Node n= new Node(null, element, null);
            head= n;
            tail= n;
            return n;
        }
            Node n= new Node(null, element, head);
            head.pred = n;
            head= n;
            return n;
    }

    /** Insert element into a new node before Node node and return the new node.
     * Precondition: node must be a Node of this list; it must not be null.
     * This operation must take constant time.  */
    Node insertBefore(E element, Node node) {
        // TODO item #10
        if (node == head) {
            return prepend(element);
        }
        size= size + 1;
        Node n= new Node(node.pred, element, node);
        node.pred.succ= n;
        node.pred= n;
        return n;

    }

    /**  Insert element in a new node of the list, making it number h.
     * The element that was number h becomes number h+1, the element that was number
     * h+1 becomes number h+2, and so on. 
     * Throw an IndexOutOfBoundsException if index < 0 or h >= size of the list.
     * Note: if h = size of the list, this means to append element.
     * This operation must take time proportional to min (h, size - index). */
    public void add(int h, E element) {
        // TODO item #11
        if (h == size)
            append(element);
        else insertBefore(element, getNode(h));
    }

    /** Remove node from this list and return its data.
     * Precondition: node must be a Node of this list; it must not be null.
     * Postcondition: To prevent memory leaks, every field of node should be set to null. */
    E removeNode(Node node) {// no access modifier. Accessible (only) in package
        // TODO item #12
        size--;
        if (node.pred == null)
            head= node.succ;
        else
            node.pred.succ = node.succ;
        if (node.succ == null)
            tail= node.pred;
        else
            node.succ.pred= node.pred;
        node.pred= null;
        node.succ= null;
        E data= node.data;
        node.data= null;
        return data;
    }

    /** Remove element number h from the list and return the element that was removed.
     * Throw an IndexOutOfBoundsException if h < 0 or h >= size of the list. */
    public E remove(int h) {
        // TODO item #13
        return removeNode(getNode(h));
    }

    /*********************/

    /** An instance is a node of this list. */
    class Node {// no access modifier. Accessible (only) in package
        /** Predecessor of this node on list (null if this is the first node). */
        Node pred; // no access modifier. Accessible (only) in package

        /** The data in this element. */
        E data; // no access modifier. Accessible (only) in package

        /** Successor of this node on list. (null if is the last node). */
        Node succ; // no access modifier. Accessible (only) in package

        /** Constructor: an instance with predecessor node p (can be null),
         * successor node s (can be null), and data e. */
        Node(Node p, E e, Node s) {// no access modifier. Accessible (only) in package
            pred= p;
            succ= s;
            data= e;
        }
    }
}
