/*
 * Decompiled with CFR 0.152.
 */
package grid;

import common.JUnitUtil;
import grid.Grid;
import grid.Tile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class GridTest {
    private void checkInvariants(Grid<?> g) {
        Assert.assertEquals((long)g.dimension, (long)g.getBounds().length);
        List<?> c = g.getAll();
        Assert.assertEquals((long)g.size(), (long)c.size());
    }

    @Test
    public void testConstruction() {
        Grid g = new Grid(new Integer[0]);
        this.checkInvariants(g);
        Assert.assertEquals((long)g.dimension, (long)0L);
        Assert.assertTrue((boolean)g.isEmpty());
        Grid g2 = new Grid(5);
        this.checkInvariants(g2);
        Assert.assertEquals((long)1L, (long)g2.dimension);
        Assert.assertEquals((long)5L, (long)g2.getBounds()[0]);
        Assert.assertTrue((boolean)g2.isEmpty());
        Integer[] d = new Integer[]{1, 2, 3, 4, 5};
        Grid g3 = new Grid(d);
        this.checkInvariants(g3);
        Assert.assertEquals((long)d.length, (long)g3.dimension);
        int i = 0;
        while (i < d.length) {
            Assert.assertEquals((long)d[i].intValue(), (long)g3.getBounds()[i]);
            ++i;
        }
        Assert.assertTrue((boolean)g3.isEmpty());
    }

    @Test
    public void testAddition() {
        Grid<IntTile> g = new Grid<IntTile>(10, 10);
        this.checkInvariants(g);
        IntTile t = new IntTile(new Integer[]{0, 0}, 2);
        boolean ok = g.add(t);
        this.checkInvariants(g);
        Assert.assertTrue((boolean)ok);
        Assert.assertTrue((boolean)g.contains(t));
        Assert.assertEquals((long)1L, (long)g.size());
        ok = g.add(t);
        this.checkInvariants(g);
        Assert.assertTrue((!ok ? 1 : 0) != 0);
        Assert.assertTrue((boolean)g.contains(t));
        Assert.assertEquals((long)1L, (long)g.size());
        IntTile t2 = new IntTile(new Integer[]{0, 1}, 4);
        ok = g.add(t2);
        this.checkInvariants(g);
        Assert.assertTrue((boolean)ok);
        Assert.assertTrue((boolean)g.contains(t));
        Assert.assertTrue((boolean)g.contains(t2));
        Assert.assertEquals((long)2L, (long)g.size());
        IntTile t3 = new IntTile(new Integer[]{0, 0}, 5);
        ok = g.add(t3);
        this.checkInvariants(g);
        Assert.assertTrue((boolean)ok);
        Assert.assertTrue((!g.contains(t) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)g.contains(t3));
        Assert.assertTrue((boolean)g.contains(t2));
        Assert.assertEquals((long)2L, (long)g.size());
        JUnitUtil.shouldFail(g::add, new IntTile(new Integer[]{11, 5}, 2), ArrayIndexOutOfBoundsException.class);
        this.checkInvariants(g);
        Assert.assertEquals((long)2L, (long)g.size());
    }

    @Test
    public void testRemove() {
        Grid<IntTile> g = new Grid<IntTile>(10, 10);
        IntTile t = new IntTile(new Integer[]{0, 0}, 3);
        g.add(t);
        g.add(new IntTile(new Integer[]{0, 1}, 4));
        this.checkInvariants(g);
        Assert.assertEquals((long)2L, (long)g.size());
        IntTile t2 = (IntTile)g.remove(0, 0);
        this.checkInvariants(g);
        Assert.assertEquals((long)1L, (long)g.size());
        Assert.assertEquals((Object)t, (Object)t2);
        Assert.assertTrue((!g.containsAt(0, 0) ? 1 : 0) != 0);
        g.clear();
        this.checkInvariants(g);
        Assert.assertEquals((long)0L, (long)g.size());
    }

    @Test
    public void testConversion() {
        Grid<IntTile> g = new Grid<IntTile>(10, 10);
        IntTile t = new IntTile(new Integer[]{0, 0}, 1);
        IntTile t2 = new IntTile(new Integer[]{0, 1}, 2);
        IntTile t3 = new IntTile(new Integer[]{1, 0}, 3);
        IntTile t4 = new IntTile(new Integer[]{1, 1}, 4);
        g.add(t);
        g.add(t2);
        g.add(t3);
        g.add(t4);
        IntTile[] a = new IntTile[]{t, t2, t3, t4};
        int i = 0;
        while (i < g.size()) {
            Assert.assertEquals((Object)a[i], (Object)g.toArray((X[])new IntTile[0])[i]);
            ++i;
        }
        HashMap<List<Integer>, IntTile> m = new HashMap<List<Integer>, IntTile>();
        IntTile[] intTileArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            IntTile x = intTileArray[n2];
            m.put(Arrays.asList(x.getLocation()), x);
            ++n2;
        }
        Assert.assertEquals(m, g.toMap());
    }

    @Test
    public void testEqualityAndHashing() {
        Grid<IntTile> g = new Grid<IntTile>(10, 10);
        Grid<IntTile> g2 = new Grid<IntTile>(10, 10);
        Grid<IntTile> g3 = new Grid<IntTile>(5, 5);
        Assert.assertTrue((boolean)g.equals(g2));
        Assert.assertTrue((g.hashCode() == g2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((!g.equals(g3) ? 1 : 0) != 0);
        Assert.assertTrue((g.hashCode() != g3.hashCode() ? 1 : 0) != 0);
        IntTile t = new IntTile(new Integer[]{0, 0}, 2);
        g.add(t);
        Assert.assertTrue((!g.equals(g2) ? 1 : 0) != 0);
        Assert.assertTrue((g.hashCode() != g2.hashCode() ? 1 : 0) != 0);
        g2.add(t);
        g3.add(t);
        Assert.assertTrue((boolean)g.equals(g2));
        Assert.assertTrue((g.hashCode() == g2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((!g.equals(g3) ? 1 : 0) != 0);
        Assert.assertTrue((g.hashCode() != g3.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals(g, (Object)g.clone());
        Assert.assertEquals(g3, (Object)g3.clone());
        Assert.assertEquals(g3, g.clone(5, 5));
    }

    @Test
    public void testGet() {
        Grid<IntTile> g = new Grid<IntTile>(5, 5);
        Integer[] loc = new Integer[]{0, 0};
        IntTile t = new IntTile(loc, 1);
        g.add(t);
        Assert.assertEquals((Object)t, g.get(loc));
        Assert.assertEquals(g.get(loc), g.getSafe(loc));
        Assert.assertEquals((long)1L, (long)((IntTile)g.get((Integer[])loc)).val);
        IntTile t2 = new IntTile(loc, 2);
        g.add(t2);
        Assert.assertEquals((Object)t2, g.get(loc));
        Assert.assertEquals(g.get(loc), g.getSafe(loc));
        Assert.assertEquals((long)2L, (long)((IntTile)g.get((Integer[])loc)).val);
        Integer[] loc2 = new Integer[]{0, 1};
        IntTile t3 = new IntTile(loc2, 3);
        g.add(t3);
        Assert.assertEquals((Object)t3, g.getFrom(t2, loc2));
        JUnitUtil.shouldFail(integerArray -> {
            Object t = g.get((Integer)integerArray);
        }, new Integer[]{-1, 0}, ArrayIndexOutOfBoundsException.class);
        Assert.assertEquals(null, g.getSafe(-1, 0));
    }

    static class IntTile
    implements Tile {
        private final Integer[] loc;
        public final int val;

        public IntTile(Integer[] loc, int v) {
            this.loc = loc;
            this.val = v;
        }

        @Override
        public Integer[] getLocation() {
            return Arrays.copyOf(this.loc, this.loc.length);
        }

        public String toString() {
            return String.valueOf(this.val) + "@" + Arrays.deepToString(this.loc);
        }
    }
}

