/*
 * Decompiled with CFR 0.152.
 */
package grid;

import java.util.Arrays;

public abstract class Direction
implements Cloneable {
    private final Integer[] delta;

    protected Direction(Integer ... d) {
        this.delta = Arrays.copyOf(d, d.length);
    }

    protected Direction(Direction ... components) {
        Direction d;
        int length = 0;
        Direction[] directionArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            d = directionArray[n2];
            length = Math.max(d.delta.length, length);
            ++n2;
        }
        this.delta = new Integer[length];
        Arrays.fill((Object[])this.delta, new Integer(0));
        directionArray = components;
        n = components.length;
        n2 = 0;
        while (n2 < n) {
            d = directionArray[n2];
            int i = 0;
            while (i < d.delta.length) {
                int n3 = i;
                this.delta[n3] = this.delta[n3] + d.delta[i];
                ++i;
            }
            ++n2;
        }
    }

    public abstract Direction clone();

    public Direction scale(double k) {
        Direction d = this.clone();
        int i = 0;
        while (i < this.delta.length) {
            d.delta[i] = (int)((double)d.delta[i].intValue() * k);
            ++i;
        }
        return d;
    }

    public final Integer[] get() {
        return Arrays.copyOf(this.delta, this.delta.length);
    }

    public String toString() {
        return Arrays.deepToString(this.delta);
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.delta);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Direction)) {
            return false;
        }
        return Arrays.deepEquals(this.delta, ((Direction)o).delta);
    }
}

