/*
 * Decompiled with CFR 0.152.
 */
package grid;

import grid.Direction;
import grid.Grid;
import grid.Tile;

public class Cursor<T extends Tile> {
    private T elm;
    public final Grid<? extends T> grid;

    public Cursor(Grid<? extends T> grid, T startingElm) {
        this.grid = grid;
        this.setElm(startingElm);
    }

    public T getElm() {
        return this.elm;
    }

    public void setElm(T t) {
        this.elm = t;
    }

    public Integer[] getLocation() {
        return this.elm.getLocation();
    }

    protected boolean willMoveTo(Direction d, T destination) {
        return destination != null;
    }

    public void move(Direction d) {
        T dest = null;
        try {
            dest = this.grid.getFrom((Tile)this.getElm(), d.get());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (this.willMoveTo(d, dest)) {
            this.setElm(dest);
            this.moved();
        }
    }

    protected void moved() {
    }

    public String toString() {
        return "Cursor on " + this.elm.toString();
    }
}

