/*
 * Decompiled with CFR 0.152.
 */
package graph;

import common.dataStructures.NotInCollectionException;
import common.types.Tuple3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Graph<V, E>
implements Cloneable {
    private boolean directed;
    private HashMap<V, Vertex> vertices = new HashMap();
    private HashMap<E, Edge> edges = new HashMap();

    public Graph(boolean directed) {
        this.directed = directed;
    }

    public Graph() {
        this(true);
    }

    public Graph(Graph<? extends V, ? extends E> g) {
        this(g.directed);
        for (V v : g.vertexSet()) {
            this.addVertex(v);
        }
        for (V e : g.edgeSet()) {
            Edge edge = g.edges.get(e);
            this.addEdge(edge.getSource().v, edge.getSink().v, e);
        }
    }

    public Graph<V, E> clone() {
        return new Graph<V, E>(this);
    }

    public Graph<V, E> unmodifiableGraph() {
        return new UnmodifiableGraph(this);
    }

    public boolean equals(Object o) {
        try {
            Graph g = (Graph)o;
            return this.isDirected() == g.isDirected() && this.vertexSet().equals(g.vertexSet()) && this.edgeSet().equals(g.edgeSet());
        }
        catch (ClassCastException ce) {
            return false;
        }
    }

    public int hashCode() {
        return Objects.hash(this.directed, this.vertices, this.edges);
    }

    public Set<V> vertexSet() {
        return new HashSet<V>(this.vertices.keySet());
    }

    public boolean containsVertex(V v) {
        return this.vertices.containsKey(v);
    }

    public int vertexSize() {
        return this.vertices.size();
    }

    protected Vertex getVertex(V v) {
        return this.vertices.get(v);
    }

    public Set<E> edgeSet() {
        return new HashSet<E>(this.edges.keySet());
    }

    public boolean containsEdge(E e) {
        return this.edges.containsKey(e);
    }

    public int edgeSize() {
        return this.edges.size();
    }

    protected Edge getEdge(E e) {
        return this.edges.get(e);
    }

    public boolean isDirected() {
        return this.directed;
    }

    public boolean addVertex(V v) {
        if (this.vertices.containsKey(v)) {
            return false;
        }
        this.vertices.put((Vertex)v, new Vertex(v));
        return true;
    }

    public boolean addEdge(V source, V sink, E e) throws NotInCollectionException {
        if (!this.vertices.containsKey(source) || !this.vertices.containsKey(sink)) {
            throw new NotInCollectionException("Can't create edge " + e, source, sink);
        }
        if (this.edges.containsKey(e)) {
            return false;
        }
        if (this.isConnected(source, sink)) {
            return false;
        }
        Vertex sourceV = this.vertices.get(source);
        Vertex sinkV = this.vertices.get(sink);
        Edge edge = new Edge(sourceV, e, sinkV);
        this.edges.put(e, edge);
        sourceV.outEdges.put(e, edge);
        sinkV.inEdges.put(e, edge);
        return true;
    }

    public boolean removeVertex(V v) {
        if (!this.vertices.containsKey(v)) {
            return false;
        }
        Vertex vertex = this.vertices.get(v);
        for (Object e : vertex.inEdges.keySet()) {
            this.removeEdge(e);
        }
        for (Object e : vertex.outEdges.keySet()) {
            this.removeEdge(e);
        }
        this.vertices.remove(v);
        return true;
    }

    public boolean removeEdge(E e) {
        if (!this.edges.containsKey(e)) {
            return false;
        }
        Edge edge = this.edges.get(e);
        Vertex source = edge.getSource();
        Vertex sink = edge.getSink();
        source.outEdges.remove(e);
        sink.inEdges.remove(e);
        this.edges.remove(e);
        return true;
    }

    public void clear() {
        this.vertices.clear();
        this.edges.clear();
    }

    public E getConnection(V source, V sink) throws NotInCollectionException {
        if (!this.vertices.containsKey(source) || !this.vertices.containsKey(sink)) {
            throw new NotInCollectionException("Can't check for connection", source, sink);
        }
        Vertex sourceV = this.vertices.get(source);
        Vertex sinkV = this.vertices.get(sink);
        for (Object e : sourceV.outEdges.keySet()) {
            if (!sinkV.inEdges.containsKey(e)) continue;
            return e;
        }
        if (!this.directed) {
            for (Object e : sourceV.inEdges.keySet()) {
                if (!sinkV.outEdges.containsKey(e)) continue;
                return e;
            }
        }
        return null;
    }

    public boolean isConnected(V source, V sink) throws NotInCollectionException {
        return this.getConnection(source, sink) != null;
    }

    public V getOther(E e, V oneEnd) throws NotInCollectionException {
        if (!this.edges.containsKey(e)) {
            throw new NotInCollectionException("Can't find other endpoint of edge", e);
        }
        Edge edge = this.edges.get(e);
        if (((Vertex)edge._1).v.equals(oneEnd)) {
            return ((Vertex)edge._3).v;
        }
        if (((Vertex)edge._3).v.equals(oneEnd)) {
            return ((Vertex)edge._1).v;
        }
        return null;
    }

    public Set<E> edgeSetOf(V v) throws NotInCollectionException {
        if (!this.vertices.containsKey(v)) {
            throw new NotInCollectionException("Can't get source and sink set", v);
        }
        HashSet e = new HashSet(this.vertices.get(v).outEdges.keySet());
        e.addAll(this.vertices.get(v).inEdges.keySet());
        return e;
    }

    public int degreeOf(V v) throws NotInCollectionException {
        if (!this.vertices.containsKey(v)) {
            throw new NotInCollectionException("Can't get degree", v);
        }
        return this.vertices.get(v).inEdges.size() + this.vertices.get(v).outEdges.size();
    }

    public Set<E> edgeSetOfSource(V source) throws NotInCollectionException {
        if (!this.vertices.containsKey(source)) {
            throw new NotInCollectionException("Can't get source set", source);
        }
        if (this.directed) {
            return new HashSet(this.vertices.get(source).outEdges.keySet());
        }
        return this.edgeSetOf(source);
    }

    public int outDegreeOf(V source) throws NotInCollectionException {
        if (!this.vertices.containsKey(source)) {
            throw new NotInCollectionException("Can't get degree", source);
        }
        if (this.directed) {
            return this.vertices.get(source).outEdges.size();
        }
        return this.degreeOf(source);
    }

    public Set<E> edgeSetOfSink(V sink) throws NotInCollectionException {
        if (!this.vertices.containsKey(sink)) {
            throw new NotInCollectionException("Can't get sink set", sink);
        }
        if (this.directed) {
            return new HashSet(this.vertices.get(sink).inEdges.keySet());
        }
        return this.edgeSetOf(sink);
    }

    public int inDegreeOf(V sink) throws NotInCollectionException {
        if (!this.vertices.containsKey(sink)) {
            throw new NotInCollectionException("Can't get degree", sink);
        }
        if (this.directed) {
            return this.vertices.get(sink).inEdges.size();
        }
        return this.degreeOf(sink);
    }

    public V sourceOf(E e) throws NotInCollectionException {
        if (!this.edges.containsKey(e)) {
            throw new NotInCollectionException("Can't get source of", e);
        }
        return this.edges.get(e).getSource().v;
    }

    public V sinkOf(E e) throws NotInCollectionException {
        if (!this.edges.containsKey(e)) {
            throw new NotInCollectionException("Can't get source of", e);
        }
        return this.edges.get(e).getSink().v;
    }

    public List<V> verticesOf(E e) throws NotInCollectionException {
        if (!this.edges.containsKey(e)) {
            throw new NotInCollectionException("Can't get verticies of", e);
        }
        Edge edge = this.edges.get(e);
        ArrayList a = new ArrayList(2);
        a.add(edge.getSource().v);
        a.add(edge.getSink().v);
        return Collections.unmodifiableList(a);
    }

    public boolean isSelfEdge(E e) throws NotInCollectionException {
        if (!this.edges.containsKey(e)) {
            throw new NotInCollectionException("Can't determine if is self edge", e);
        }
        return this.sourceOf(e).equals(this.sinkOf(e));
    }

    public boolean isEndpointOf(E e, V endpoint) throws NotInCollectionException {
        if (!this.edges.containsKey(e)) {
            throw new NotInCollectionException("Can't determine if isEndpoint", e);
        }
        return endpoint.equals(this.sourceOf(e)) || endpoint.equals(this.sinkOf(e));
    }

    public V getSharedEndpoint(E e1, E e2) throws NotInCollectionException {
        if (!this.edges.containsKey(e1) || !this.edges.containsKey(e2)) {
            throw new NotInCollectionException("Can't getSharedEndpoint", e1, e2);
        }
        V v11 = this.sourceOf(e1);
        V v12 = this.sinkOf(e1);
        V v21 = this.sourceOf(e2);
        V v22 = this.sinkOf(e2);
        if (v11.equals(v21)) {
            return v11;
        }
        if (v11.equals(v22)) {
            return v11;
        }
        if (v12.equals(v21)) {
            return v12;
        }
        if (v12.equals(v22)) {
            return v22;
        }
        return null;
    }

    public Set<V> neighborsOf(V v) throws NotInCollectionException {
        if (!this.vertices.containsKey(v)) {
            throw new NotInCollectionException("Can't get neighbor set", v);
        }
        Vertex vertex = this.vertices.get(v);
        HashSet neighbors = new HashSet();
        for (Edge e : vertex.outEdges.values()) {
            neighbors.add(e.getSink().v);
        }
        if (!this.directed) {
            for (Edge e : vertex.inEdges.values()) {
                neighbors.add(e.getSource().v);
            }
        }
        return neighbors;
    }

    public Set<V> sharedNeighborsOf(V v1, V v2) throws NotInCollectionException {
        Set<V> neighbors = this.neighborsOf(v1);
        neighbors.retainAll(this.neighborsOf(v2));
        return neighbors;
    }

    protected class Edge
    extends Tuple3<Vertex, E, Vertex> {
        protected Edge(Vertex first, E second, Vertex third) {
            super(first, second, third);
        }

        public Vertex getSource() {
            return (Vertex)this._1;
        }

        public Vertex getSink() {
            return (Vertex)this._3;
        }
    }

    protected class UnmodifiableGraph
    extends Graph<V, E> {
        private final Graph<V, E> graph;

        private UnmodifiableGraph(Graph<V, E> g) {
            if (g == null) {
                throw new IllegalArgumentException("Can't View Null Graph");
            }
            this.graph = g;
        }

        @Override
        public Graph<V, E> clone() {
            return this.graph.clone();
        }

        public UnmodifiableGraph unmodifiableGraph() {
            return this;
        }

        @Override
        public boolean equals(Object o) {
            return this.graph.equals(o);
        }

        @Override
        public int hashCode() {
            return this.graph.hashCode();
        }

        @Override
        public Set<V> vertexSet() {
            return this.graph.vertexSet();
        }

        @Override
        public int vertexSize() {
            return this.graph.vertexSize();
        }

        @Override
        public boolean containsVertex(V v) {
            return this.graph.containsVertex(v);
        }

        @Override
        protected Vertex getVertex(V v) {
            return this.graph.getVertex(v);
        }

        @Override
        public Set<E> edgeSet() {
            return this.graph.edgeSet();
        }

        @Override
        public boolean containsEdge(E e) {
            return this.graph.containsEdge(e);
        }

        @Override
        public int edgeSize() {
            return this.graph.edgeSize();
        }

        @Override
        protected Edge getEdge(E e) {
            return this.graph.getEdge(e);
        }

        @Override
        public boolean isDirected() {
            return this.graph.isDirected();
        }

        @Override
        public boolean addVertex(V v) {
            throw new UnsupportedOperationException("Can't Modify UnmodifiableGraph");
        }

        @Override
        public boolean addEdge(V source, V sink, E e) {
            throw new UnsupportedOperationException("Can't Modify UnmodifiableGraph");
        }

        @Override
        public boolean removeVertex(V v) {
            throw new UnsupportedOperationException("Can't Modify UnmodifiableGraph");
        }

        @Override
        public boolean removeEdge(E e) {
            throw new UnsupportedOperationException("Can't Modify UnmodifiableGraph");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Can't Modify UnmodifiableGraph");
        }

        @Override
        public E getConnection(V source, V sink) {
            return this.graph.getConnection(source, sink);
        }

        @Override
        public boolean isConnected(V source, V sink) {
            return this.graph.isConnected(source, sink);
        }

        @Override
        public V getOther(E e, V oneEnd) {
            return this.graph.getOther(e, oneEnd);
        }

        @Override
        public Set<E> edgeSetOf(V v) {
            return this.graph.edgeSetOf(v);
        }

        @Override
        public Set<E> edgeSetOfSource(V source) {
            return this.graph.edgeSetOfSource(source);
        }

        @Override
        public Set<E> edgeSetOfSink(V sink) {
            return this.graph.edgeSetOfSink(sink);
        }

        @Override
        public int degreeOf(V v) {
            return this.graph.degreeOf(v);
        }

        @Override
        public int outDegreeOf(V source) {
            return this.graph.outDegreeOf(source);
        }

        @Override
        public int inDegreeOf(V sink) {
            return this.graph.inDegreeOf(sink);
        }

        @Override
        public V sourceOf(E e) {
            return this.graph.sourceOf(e);
        }

        @Override
        public V sinkOf(E e) {
            return this.graph.sinkOf(e);
        }

        @Override
        public List<V> verticesOf(E e) {
            return this.graph.verticesOf(e);
        }

        @Override
        public boolean isSelfEdge(E e) {
            return this.graph.isSelfEdge(e);
        }

        @Override
        public boolean isEndpointOf(E e, V endpoint) {
            return this.graph.isEndpointOf(e, endpoint);
        }

        @Override
        public V getSharedEndpoint(E e1, E e2) {
            return this.graph.getSharedEndpoint(e1, e2);
        }

        @Override
        public Set<V> neighborsOf(V v) {
            return this.graph.neighborsOf(v);
        }
    }

    protected class Vertex {
        protected HashMap<E, Edge> outEdges;
        protected HashMap<E, Edge> inEdges;
        public final V v;

        protected Vertex(V v) {
            this.v = v;
            this.outEdges = new HashMap();
            this.inEdges = new HashMap();
        }

        public boolean equals(Object o) {
            try {
                Vertex vertex = (Vertex)o;
                return this.v.equals(vertex.v);
            }
            catch (ClassCastException ce) {
                return false;
            }
        }

        public int hashCode() {
            return this.v.hashCode();
        }

        public String toString() {
            return this.v.toString();
        }
    }
}

