/*
 * Decompiled with CFR 0.152.
 */
package functional;

import functional.BiPredicate;
import functional.Predicate;
import functional.Supplier;
import functional.TriConsumer;
import functional.TriFuncShell;
import java.util.Objects;

@FunctionalInterface
public interface TriPredicate<A, B, C>
extends TriFuncShell<A, B, C> {
    public boolean apply(A var1, B var2, C var3);

    default public boolean test(A a, B b, C c) {
        return this.apply(a, b, c);
    }

    @Override
    default public Supplier<Boolean> partialApply(A a, B b, C c) {
        return () -> this.apply(a, b, c);
    }

    @Override
    default public Predicate<C> partialApply(A a, B b) {
        return c -> this.apply(a, b, c);
    }

    @Override
    default public BiPredicate<B, C> partialApply(A a) {
        return (b, c) -> this.apply(a, b, c);
    }

    @Override
    default public TriConsumer<A, B, C> discardReturn() {
        return (a, b, c) -> {
            boolean bl = this.apply(a, b, c);
        };
    }

    default public TriPredicate<C, A, B> rotate() {
        return (c, a, b) -> this.apply(a, b, c);
    }

    default public TriPredicate<A, B, C> negate() {
        return (a, b, c) -> !this.apply(a, b, c);
    }

    default public TriPredicate<A, B, C> and(TriPredicate<A, B, C> other) {
        Objects.requireNonNull(other);
        return (a, b, c) -> this.apply(a, b, c) && other.apply(a, b, c);
    }

    default public TriPredicate<A, B, C> or(TriPredicate<A, B, C> other) {
        Objects.requireNonNull(other);
        return (a, b, c) -> this.apply(a, b, c) || other.apply(a, b, c);
    }

    default public TriPredicate<A, B, C> nand(TriPredicate<A, B, C> other) {
        Objects.requireNonNull(other);
        return (a, b, c) -> !this.apply(a, b, c) || !other.apply(a, b, c);
    }

    default public TriPredicate<A, B, C> nor(TriPredicate<A, B, C> other) {
        Objects.requireNonNull(other);
        return (a, b, c) -> !this.apply(a, b, c) && !other.apply(a, b, c);
    }

    default public TriPredicate<A, B, C> xor(TriPredicate<A, B, C> other) {
        Objects.requireNonNull(other);
        return (a, b, c) -> this.apply(a, b, c) ^ other.apply(a, b, c);
    }

    default public TriPredicate<A, B, C> xnor(TriPredicate<A, B, C> other) {
        Objects.requireNonNull(other);
        return (a, b, c) -> !(this.apply(a, b, c) ^ other.apply(a, b, c));
    }
}

