/*
 * Decompiled with CFR 0.152.
 */
package functional;

import common.dataStructures.DeArrList;
import common.types.Tuple;
import common.types.Tuple2;
import functional.BiFunction;
import functional.Consumer;
import functional.Function;
import functional.Predicate;
import functional.Supplier;
import functional.TriFunction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import java.util.function.UnaryOperator;

public class FunctionalUtil {
    public static Consumer<Integer> asGeneric(IntConsumer intConsumer) {
        return i -> intConsumer.accept((int)i);
    }

    public static UnaryOperator<Integer> asGeneric(IntUnaryOperator intFunction) {
        return i -> intFunction.applyAsInt((int)i);
    }

    public static <R> Function<Integer, R> asGeneric(IntFunction<R> intFunction) {
        return i -> intFunction.apply((int)i);
    }

    public static Predicate<Integer> asGeneric(IntPredicate intPredicate) {
        return i -> intPredicate.test((int)i);
    }

    public static Supplier<Integer> asGeneric(IntSupplier intSupplier) {
        return () -> intSupplier.getAsInt();
    }

    public static Consumer<Long> asGeneric(LongConsumer longConsumer) {
        return l -> longConsumer.accept((long)l);
    }

    public static UnaryOperator<Long> asGeneric(LongUnaryOperator longFunction) {
        return l -> longFunction.applyAsLong((long)l);
    }

    public static <R> Function<Long, R> asGeneric(LongFunction<R> longFunction) {
        return l -> longFunction.apply((long)l);
    }

    public static Predicate<Long> asGeneric(LongPredicate longPredicate) {
        return l -> longPredicate.test((long)l);
    }

    public static Supplier<Long> asGeneric(LongSupplier longSupplier) {
        return () -> longSupplier.getAsLong();
    }

    public static Consumer<Double> asGeneric(DoubleConsumer doubleConsumer) {
        return d -> doubleConsumer.accept((double)d);
    }

    public static UnaryOperator<Double> asGeneric(DoubleUnaryOperator doubleFunction) {
        return d -> doubleFunction.applyAsDouble((double)d);
    }

    public static <R> Function<Double, R> asGeneric(DoubleFunction<R> doubleFunction) {
        return d -> doubleFunction.apply((double)d);
    }

    public static Predicate<Double> asGeneric(DoublePredicate doublePredicate) {
        return d -> doublePredicate.test((double)d);
    }

    public static Supplier<Double> asGeneric(DoubleSupplier doubleSupplier) {
        return () -> doubleSupplier.getAsDouble();
    }

    public static void forEach(int[] arr, Consumer<Integer> f) {
        int i = 0;
        while (i < arr.length) {
            f.apply(arr[i]);
            ++i;
        }
    }

    public static void forEach(double[] arr, Consumer<Double> f) {
        int i = 0;
        while (i < arr.length) {
            f.apply(arr[i]);
            ++i;
        }
    }

    public static void forEach(long[] arr, Consumer<Long> f) {
        int i = 0;
        while (i < arr.length) {
            f.apply(arr[i]);
            ++i;
        }
    }

    public static <T> void forEach(T[] arr, Consumer<T> f) {
        int i = 0;
        while (i < arr.length) {
            f.apply(arr[i]);
            ++i;
        }
    }

    public static <T> void forEach(Iterable<T> col, Consumer<T> f) {
        for (T t : col) {
            f.apply(t);
        }
    }

    public static <T, S> List<S> map(T[] arr, Function<T, S> f) {
        DeArrList<S> lst = new DeArrList<S>();
        T[] TArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            lst.add(f.apply(t));
            ++n2;
        }
        return lst;
    }

    public static <T, S> List<S> map(Iterable<T> col, Function<T, S> f) {
        DeArrList<S> lst = new DeArrList<S>();
        for (T t : col) {
            lst.add(f.apply(t));
        }
        return lst;
    }

    public static <T, R> R foldLeft(R start, T[] arr, BiFunction<R, T, R> f) {
        return FunctionalUtil.foldLeft(start, Arrays.asList(arr), f);
    }

    public static <T, R> R foldLeft(R start, Iterable<T> col, BiFunction<R, T, R> f) {
        for (T t : col) {
            start = f.apply(start, t);
        }
        return start;
    }

    public static <T, S, R> R foldLeft2(R start, T[] arr, S[] arr2, TriFunction<R, T, S, R> f) {
        int min = Math.min(arr.length, arr2.length);
        int i = 0;
        while (i < min) {
            start = f.apply(start, arr[i], arr2[i]);
            ++i;
        }
        return start;
    }

    public static <T, S, R> R foldLeft2(R start, Iterable<T> col, Iterable<S> col2, TriFunction<R, T, S, R> f) {
        Iterator<T> c = col.iterator();
        Iterator<S> c2 = col2.iterator();
        while (c.hasNext() && c2.hasNext()) {
            start = f.apply(start, c.next(), c2.next());
        }
        return start;
    }

    public static <T> List<T> filter(T[] col, Predicate<T> f) {
        return FunctionalUtil.filter(Arrays.asList(col), f);
    }

    public static <T> List<T> filter(Iterable<T> col, Predicate<T> f) {
        DeArrList<T> lst = new DeArrList<T>();
        for (T t : col) {
            if (!f.apply(t)) continue;
            lst.add(t);
        }
        return lst;
    }

    public static <T, U> List<Tuple2<T, U>> zip(List<T> lst, List<U> lst2) {
        DeArrList<Tuple2<T, U>> zLst = new DeArrList<Tuple2<T, U>>();
        Iterator<T> i = lst.iterator();
        Iterator<U> i2 = lst2.iterator();
        while (i.hasNext() && i2.hasNext()) {
            zLst.add(Tuple.of(i.next(), i2.next()));
        }
        while (i.hasNext()) {
            zLst.add(Tuple.of(i.next(), null));
        }
        while (i2.hasNext()) {
            zLst.add(Tuple.of(null, i2.next()));
        }
        return zLst;
    }

    private FunctionalUtil() {
    }
}

