/*
 * Decompiled with CFR 0.152.
 */
package functional;

import functional.BiFuncShell;
import functional.BiFunction;
import functional.Function;
import functional.Predicate;
import functional.SingleFuncShell;
import functional.Supplier;
import functional.TriFunction;
import functional.UnitFuncShell;
import org.junit.Assert;
import org.junit.Test;

public class FunctionalTest {
    @Test
    public void testCurrying() {
        TriFunction<Integer, Integer, Integer, Integer> f3 = (a, b, c) -> a + b * c;
        BiFuncShell f3_c1 = f3.partialApply((Object)5);
        BiFunction<Integer, Integer, Integer> f2 = (a, b) -> 5 + a * b;
        int i = -5;
        while (i < 5) {
            int j = -5;
            while (j < 5) {
                Assert.assertEquals((Object)f2.apply(i, j), f3_c1.apply(i, j));
                ++j;
            }
            ++i;
        }
        SingleFuncShell f3_c2 = f3.partialApply((Object)5, (Object)3);
        SingleFuncShell f2_c1 = f2.partialApply((Object)3);
        Function<Integer, Integer> f1 = a -> 5 + 3 * a;
        int i2 = -5;
        while (i2 < 5) {
            Assert.assertEquals((Object)f1.apply(i2), f2_c1.apply(i2));
            Assert.assertEquals((Object)f1.apply(i2), f3_c2.apply(i2));
            ++i2;
        }
        UnitFuncShell f3_c3 = f3.partialApply((Object)5, (Object)3, (Object)2);
        UnitFuncShell f2_c2 = f2.partialApply((Object)3, (Object)2);
        UnitFuncShell f1_c1 = f1.partialApply((Object)2);
        Supplier<Integer> s = () -> 11;
        Assert.assertEquals((Object)s.apply(), f3_c3.apply());
        Assert.assertEquals((Object)s.apply(), f2_c2.apply());
        Assert.assertEquals((Object)s.apply(), f1_c1.apply());
    }

    @Test
    public void testAndThen() {
        Function<Integer, Integer> f1 = a -> a + 2;
        Function<Integer, Integer> f2 = a -> -a.intValue();
        Assert.assertEquals((long)-5L, (long)((Integer)f1.andThen(f2).apply(3)).intValue());
        Assert.assertEquals((long)-1L, (long)((Integer)f2.andThen(f1).apply(3)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)f2.andThen(f1).andThen(f1).apply(3)).intValue());
    }

    @Test
    public void testPredicateLogic() {
        Predicate<Integer> p1 = a -> a > 5;
        Predicate<Integer> p2 = a -> a < 8;
        Assert.assertTrue((boolean)p1.apply(8));
        Assert.assertFalse((boolean)p1.apply(5));
        Assert.assertTrue((boolean)p2.apply(3));
        Assert.assertFalse((boolean)p2.apply(9));
        Assert.assertTrue((boolean)p1.negate().apply(3));
        Assert.assertFalse((boolean)p1.negate().apply(7));
        Assert.assertTrue((boolean)p1.negate().negate().apply(7));
        Assert.assertTrue((boolean)p1.and(p2).apply(6));
        Assert.assertFalse((boolean)p1.and(p2).apply(4));
        Assert.assertFalse((boolean)p1.and(p2).apply(9));
        Assert.assertTrue((boolean)p1.and(p2.negate()).apply(10));
    }
}

