/*
 * Decompiled with CFR 0.152.
 */
package concurrent;

import concurrent.Monitorable;

public class TimeRemainingWorker
extends Thread {
    public static final int DEFAULT_UPDATE_INTERVAL = 1;
    public static final double DEFAULT_COMPLETED_VALUE = 100.0;
    private Monitorable watch;
    private long startTime = -1L;
    private long finishTime = -1L;
    private boolean running = false;
    private double[] x = new double[]{0.0, 0.0};
    private double[] y = new double[]{0.0, 0.0};
    private double completedValue = 100.0;
    private int updateInterval = 1;
    private int timeRemaining = -1;
    private double percentComplete = -1.0;

    public TimeRemainingWorker(Monitorable toWatch) {
        this(toWatch, 1, 100.0);
    }

    public TimeRemainingWorker(Monitorable toWatch, int updateInterval, double completedValue) throws IllegalArgumentException {
        this.watch = toWatch;
        if (updateInterval <= 0 || completedValue <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.updateInterval = updateInterval;
        this.completedValue = completedValue;
        this.setName(String.valueOf(toWatch.getName()) + " - Time Worker");
    }

    public boolean getRunning() {
        return this.running;
    }

    public void cancel() {
        this.running = false;
        this.interrupt();
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public void setUpdateInterval(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.updateInterval = n;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public int getTimeRemaining() {
        return this.timeRemaining;
    }

    public double getCompletedValue() {
        return this.completedValue;
    }

    public double getCurrentCompletion() {
        return this.watch.getCompletionValue();
    }

    public double getPercentComplete() {
        return this.percentComplete;
    }

    public Monitorable getMonitorable() {
        return this.watch;
    }

    @Override
    public final void run() {
        this.running = true;
        this.startTime = System.currentTimeMillis();
        while (this.running) {
            try {
                TimeRemainingWorker.sleep(this.updateInterval * 1000);
            }
            catch (InterruptedException e) {
                break;
            }
            this.x[0] = this.x[1];
            this.x[1] = System.currentTimeMillis() / 1000L - this.startTime / 1000L;
            this.y[0] = this.y[1];
            this.y[1] = this.watch.getCompletionValue();
            this.timeRemaining = this.timeRemaining();
            this.percentComplete = this.getCurrentCompletion() / this.getCompletedValue();
            this.watch.update();
        }
        this.finishTime = System.currentTimeMillis();
    }

    private int timeRemaining() {
        double slope = (this.y[1] - this.y[0]) / (this.x[1] - this.x[0]);
        double intersect = this.y[0] - slope * this.x[0];
        int finishTime = (int)((this.completedValue - intersect) / slope);
        return Math.max(finishTime - (int)this.x[1], 0);
    }
}

