/*
 * Decompiled with CFR 0.152.
 */
package concurrent;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReentrantLock;

public class SemaphoreGroup {
    private final boolean fair;
    private final HashMap<String, Integer> permits;
    private final HashMap<String, Semaphore> semaphores;
    private final ReentrantLock operationLock;
    private final HashMap<Thread, Map<String, Integer>> threads;
    private final List<Thread> waitingThreads;
    private static final boolean DEBUG = false;

    public SemaphoreGroup(Map<String, Integer> permits, boolean fair) {
        this.permits = new HashMap<String, Integer>(permits);
        this.fair = fair;
        this.operationLock = new ReentrantLock();
        this.semaphores = new HashMap();
        this.threads = new HashMap();
        this.waitingThreads = Collections.synchronizedList(new LinkedList());
        for (String s : permits.keySet()) {
            this.semaphores.put(s, new Semaphore(permits.get(s)));
        }
    }

    private void startOperation() {
        if (!this.operationLock.isHeldByCurrentThread()) {
            this.operationLock.lock();
        }
    }

    private void endOperation() {
        if (this.operationLock.isHeldByCurrentThread()) {
            this.operationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseThread() throws InterruptedException {
        if (this.fair) {
            Thread t;
            Thread thread = t = Thread.currentThread();
            synchronized (thread) {
                t.wait();
            }
        }
        ReentrantLock reentrantLock = this.operationLock;
        synchronized (reentrantLock) {
            this.operationLock.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeThread() {
        if (this.fair) {
            List<Thread> list = this.waitingThreads;
            synchronized (list) {
                Thread t;
                Thread thread = t = this.waitingThreads.get(0);
                synchronized (thread) {
                    t.notify();
                }
            }
        }
        ReentrantLock reentrantLock = this.operationLock;
        synchronized (reentrantLock) {
            this.operationLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(Map<String, Integer> permits) throws InterruptedException, IllegalArgumentException {
        try {
            this.startOperation();
            for (Map.Entry<String, Integer> e : permits.entrySet()) {
                Semaphore s = this.semaphores.get(e.getKey());
                if (s == null) {
                    throw new IllegalArgumentException("Illegal Permit Name " + e.getKey() + " Not in " + this);
                }
                if (e.getValue() < 0) {
                    throw new IllegalArgumentException("Illegal Permit Value " + e.getValue() + " Must be positive");
                }
                if (s.availablePermits() >= e.getValue()) continue;
                this.endOperation();
                List<Thread> list = this.waitingThreads;
                synchronized (list) {
                    this.waitingThreads.remove(Thread.currentThread());
                    this.waitingThreads.add(Thread.currentThread());
                }
                this.pauseThread();
                this.acquire(permits);
                list = this.waitingThreads;
                synchronized (list) {
                    this.waitingThreads.remove(Thread.currentThread());
                }
                return;
            }
            for (Map.Entry<String, Integer> e : permits.entrySet()) {
                this.semaphores.get(e.getKey()).acquire(e.getValue());
            }
            Thread t = Thread.currentThread();
            Map<String, Integer> currentlyOwned = this.threads.get(t);
            if (currentlyOwned == null) {
                this.threads.put(t, new HashMap<String, Integer>(permits));
            } else {
                HashMap<String, Integer> totalOwned = new HashMap<String, Integer>(permits);
                for (Map.Entry<String, Integer> e : permits.entrySet()) {
                    totalOwned.put(e.getKey(), e.getValue() + (totalOwned.get(e.getKey()) == null ? 0 : currentlyOwned.get(e.getKey())));
                }
                this.threads.put(t, totalOwned);
            }
        }
        finally {
            this.endOperation();
        }
    }

    public Map<String, Integer> drain() throws InterruptedException {
        try {
            this.startOperation();
            Map<String, Integer> m = this.getAvailablePermits();
            this.acquire(m);
            Map<String, Integer> map = m;
            return map;
        }
        finally {
            this.endOperation();
        }
    }

    public void release(Map<String, Integer> permits) throws InterruptedException {
        try {
            this.startOperation();
            Thread t = Thread.currentThread();
            if (!this.threads.containsKey(t)) {
                return;
            }
            for (Map.Entry<String, Integer> e : permits.entrySet()) {
                Semaphore s = this.semaphores.get(e.getKey());
                if (s == null) {
                    throw new IllegalArgumentException("Illegal Permit Name " + e.getKey() + " Not in " + this);
                }
                int has = this.threads.get(t).containsKey(e.getKey()) ? this.threads.get(t).get(e.getKey()) : 0;
                int toRemove = Math.min(e.getValue(), has);
                s.release(toRemove);
                this.threads.get(t).put(e.getKey(), has - toRemove);
            }
            this.resumeThread();
        }
        finally {
            this.endOperation();
        }
    }

    public void releaseAll() throws InterruptedException {
        try {
            this.startOperation();
            Thread t = Thread.currentThread();
            if (!this.threads.containsKey(t)) {
                return;
            }
            HashMap<String, Integer> permits = new HashMap<String, Integer>(this.threads.get(t));
            this.release(permits);
        }
        finally {
            this.endOperation();
        }
    }

    public Map<String, Integer> getAvailablePermits() {
        HashMap<String, Integer> available = new HashMap<String, Integer>();
        for (Map.Entry<String, Semaphore> e : this.semaphores.entrySet()) {
            available.put(e.getKey(), e.getValue().availablePermits());
        }
        return available;
    }

    public Set<String> getIdentifyingStrings() {
        return this.semaphores.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Thread> getQueuedThreads() {
        List<Thread> list = this.waitingThreads;
        synchronized (list) {
            return new LinkedList<Thread>(this.waitingThreads);
        }
    }

    public int getQueueLength() {
        return this.waitingThreads.size();
    }

    public boolean isFair() {
        return this.fair;
    }

    public String toString() {
        Map<String, Integer> available = this.getAvailablePermits();
        String s = "{";
        for (Map.Entry<String, Integer> e : this.permits.entrySet()) {
            s = String.valueOf(s) + e.getKey() + "=" + available.get(e.getKey()) + "/" + e.getValue() + ", ";
        }
        return String.valueOf(s.substring(0, s.length() - 2)) + "}";
    }
}

