/*
 * Decompiled with CFR 0.152.
 */
package common.dataStructures.util;

import functional.Supplier;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class SmartIterator<T>
implements Iterator<T> {
    private Iterator<T> wrappedIter;
    private int expectedModCount;
    private Supplier<Integer> modCountSupplier;

    public SmartIterator(Iterable<T> iterable, Supplier<Integer> getExpectedModCount) {
        this(iterable.iterator(), getExpectedModCount);
    }

    public SmartIterator(Iterator<T> iter, Supplier<Integer> getExpectedModCount) {
        this.wrappedIter = iter;
        this.modCountSupplier = getExpectedModCount;
        this.expectedModCount = getExpectedModCount.apply();
    }

    @Override
    public boolean hasNext() throws ConcurrentModificationException {
        if (this.expectedModCount != this.modCountSupplier.apply()) {
            throw new ConcurrentModificationException();
        }
        return this.wrappedIter.hasNext();
    }

    @Override
    public T next() {
        return this.wrappedIter.next();
    }

    @Override
    public void remove() {
        this.wrappedIter.remove();
        this.expectedModCount = this.modCountSupplier.apply();
    }
}

