/*
 * Decompiled with CFR 0.152.
 */
package common.dataStructures;

import common.dataStructures.UnionFind;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class UnionFindTest {
    @Test
    public void testConstruction() {
        UnionFind<String> a = new UnionFind<String>();
        a.add("A");
        a.add("B");
        a.add("C");
        HashSet<String> s = new HashSet<String>();
        s.add("A");
        s.add("B");
        s.add("C");
        Assert.assertEquals(s, a.toElmSet());
        UnionFind a2 = new UnionFind(s);
        Assert.assertEquals(s, a2.toElmSet());
        a.add("C");
        Assert.assertEquals(s, a.toElmSet());
        a.add("D");
        Assert.assertFalse((boolean)s.equals(a.toElmSet()));
    }

    @Test
    public void testUnionFind() {
        UnionFind<String> a = new UnionFind<String>();
        a.add("A");
        a.add("B");
        a.add("C");
        Assert.assertEquals((Object)"A", (Object)a.find("A"));
        Assert.assertEquals((Object)"B", (Object)a.find("B"));
        Assert.assertEquals((Object)"C", (Object)a.find("C"));
        Assert.assertEquals((long)1L, (long)a.size("A"));
        Assert.assertEquals((long)1L, (long)a.size("B"));
        Assert.assertEquals((long)1L, (long)a.size("C"));
        Assert.assertFalse((boolean)a.isUnion("A", "B"));
        Assert.assertFalse((boolean)a.isUnion("A", "C"));
        Assert.assertFalse((boolean)a.isUnion("B", "C"));
        String parent = a.union("A", "B");
        String other = parent.equals("A") ? "B" : "A";
        Assert.assertEquals((Object)parent, (Object)a.find("A"));
        Assert.assertEquals((Object)parent, (Object)a.find("B"));
        Assert.assertEquals((long)2L, (long)a.size(parent));
        Assert.assertEquals((long)2L, (long)a.size(other));
        Assert.assertTrue((boolean)a.isUnion("A", "B"));
        Assert.assertFalse((boolean)a.isUnion("A", "C"));
        Assert.assertFalse((boolean)a.isUnion("B", "C"));
        Assert.assertEquals((Object)"C", (Object)a.find("C"));
        Assert.assertEquals((long)1L, (long)a.size("C"));
        parent = a.union("A", "C");
        Assert.assertEquals((Object)parent, (Object)a.find("A"));
        Assert.assertEquals((Object)parent, (Object)a.find("B"));
        Assert.assertEquals((Object)parent, (Object)a.find("C"));
        Assert.assertEquals((long)3L, (long)a.size(parent));
        Assert.assertEquals((long)3L, (long)a.size("C"));
        Assert.assertTrue((boolean)a.isUnion("A", "B"));
        Assert.assertTrue((boolean)a.isUnion("A", "C"));
        Assert.assertTrue((boolean)a.isUnion("B", "C"));
    }
}

