/*
 * Decompiled with CFR 0.152.
 */
package common.dataStructures;

import common.dataStructures.NotInCollectionException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class UnionFind<E> {
    private HashMap<E, Node<E>> elms = new HashMap();

    public UnionFind() {
    }

    public UnionFind(Set<E> elms) {
        this();
        for (E e : elms) {
            this.add(e);
        }
    }

    public boolean add(E e) {
        if (this.elms.containsKey(e)) {
            return false;
        }
        this.elms.put(e, new Node(e));
        return true;
    }

    public Set<E> toElmSet() {
        return new HashSet<E>(this.elms.keySet());
    }

    public Set<Set<E>> toUnionSet() {
        HashSet h = new HashSet();
        for (E e : this.elms.keySet()) {
            boolean added = false;
            for (Set<E> set : h) {
                E setElm = set.iterator().next();
                if (!this.isUnion(e, setElm)) continue;
                set.add(e);
                added = true;
                break;
            }
            if (added) continue;
            HashSet<E> hashSet = new HashSet<E>();
            hashSet.add(e);
            h.add(hashSet);
        }
        return h;
    }

    public E find(E elm) throws NotInCollectionException {
        if (!this.elms.containsKey(elm)) {
            throw new NotInCollectionException("Can't find ", elm);
        }
        return this.find(this.elms.get(elm));
    }

    private E find(Node<E> n) {
        if (((Node)n).parent == n) {
            return (E)((Node)n).val;
        }
        E val = this.find(((Node)n).parent);
        ((Node)n).parent = (Node)this.elms.get(val);
        ((Node)n).size = 1;
        return val;
    }

    public int size(E elm) throws NotInCollectionException {
        if (!this.elms.containsKey(elm)) {
            throw new NotInCollectionException("Can't get size of ", elm);
        }
        return ((Node)this.elms.get(this.find(elm))).size;
    }

    public E union(E elm1, E elm2) throws NotInCollectionException {
        Node<E> p2;
        if (!this.elms.containsKey(elm1) || !this.elms.containsKey(elm2)) {
            throw new NotInCollectionException("Can't union ", elm1, elm2);
        }
        Node<E> p1 = this.elms.get(this.find(elm1));
        if (p1 == (p2 = this.elms.get(this.find(elm2)))) {
            return (E)((Node)p1).val;
        }
        if (((Node)p1).size < ((Node)p2).size) {
            ((Node)p1).parent = (Node)p2;
            Node<E> node = p2;
            ((Node)node).size = ((Node)node).size + ((Node)p1).size;
            return (E)((Node)p2).val;
        }
        ((Node)p2).parent = (Node)p1;
        Node<E> node = p1;
        ((Node)node).size = ((Node)node).size + ((Node)p2).size;
        return (E)((Node)p1).val;
    }

    public boolean isUnion(E elm1, E elm2) throws NotInCollectionException {
        if (!this.elms.containsKey(elm1) || !this.elms.containsKey(elm2)) {
            throw new NotInCollectionException("Can't check union of ", elm1, elm2);
        }
        return this.find(elm1).equals(this.find(elm2));
    }

    private static class Node<E> {
        private Node<E> parent;
        private E val;
        private int size;

        private Node(E val) {
            this.val = val;
            this.parent = this;
            this.size = 1;
        }

        public String toString() {
            return this.parent == this ? this.val.toString() : this.val + "->" + this.parent.toString();
        }
    }
}

