/*
 * Decompiled with CFR 0.152.
 */
package common.dataStructures;

import common.dataStructures.DeArrList;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class StressTest {
    private static final int BIG_VAL = 200000;
    private static final float TOLERANCE = 1.1f;

    @Test
    public void testArrayListsPrepend() {
        ArrayList<Integer> arr1 = new ArrayList<Integer>();
        DeArrList<Integer> arr2 = new DeArrList<Integer>();
        long startTime = System.currentTimeMillis();
        int i = 0;
        while (i < 200000) {
            arr1.add(0, i);
            Assert.assertEquals((long)((Integer)arr1.get(0)).intValue(), (long)i);
            ++i;
        }
        Assert.assertEquals((long)arr1.size(), (long)200000L);
        long arr1Time = System.currentTimeMillis() - startTime;
        System.out.println("Standard Implementation Prepend " + arr1Time + "ms");
        startTime = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 200000) {
            arr2.add(0, i2);
            Assert.assertEquals((long)((Integer)arr2.get(0)).intValue(), (long)i2);
            ++i2;
        }
        Assert.assertEquals((long)arr2.size(), (long)200000L);
        long arr2Time = System.currentTimeMillis() - startTime;
        System.out.println("My Implementation Prepend " + arr2Time + "ms");
        Assert.assertTrue(((float)arr2Time < (float)arr1Time * 1.1f ? 1 : 0) != 0);
    }

    @Test
    public void testArrayListsAdd() {
        ArrayList<Integer> arr1 = new ArrayList<Integer>();
        DeArrList<Integer> arr2 = new DeArrList<Integer>();
        long startTime = System.currentTimeMillis();
        int i = 0;
        while (i < 200000) {
            int index = (int)(Math.random() * (double)(arr1.size() + 1));
            arr1.add(index, i);
            Assert.assertEquals((long)i, (long)((Integer)arr1.get(index)).intValue());
            ++i;
        }
        Assert.assertEquals((long)arr1.size(), (long)200000L);
        long arr1Time = System.currentTimeMillis() - startTime;
        System.out.println("Standard Implementation Add " + arr1Time + "ms");
        startTime = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 200000) {
            int index = (int)(Math.random() * (double)(arr2.size() + 1));
            arr2.add(index, i2);
            Assert.assertEquals((long)i2, (long)((Integer)arr2.get(index)).intValue());
            ++i2;
        }
        Assert.assertEquals((long)arr2.size(), (long)200000L);
        long arr2Time = System.currentTimeMillis() - startTime;
        System.out.println("My Implementation Add " + arr2Time + "ms");
        Assert.assertTrue(((float)arr2Time < (float)arr1Time * 1.1f ? 1 : 0) != 0);
    }

    @Test
    public void testRemove() {
        ArrayList<Integer> arr1 = new ArrayList<Integer>();
        DeArrList<Integer> arr2 = new DeArrList<Integer>();
        int i = 0;
        while (i < 200000) {
            arr1.add(0, i);
            arr2.add(0, i);
            ++i;
        }
        long startTime = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 200000) {
            arr1.remove((int)(Math.random() * (double)arr1.size()));
            ++i2;
        }
        Assert.assertEquals((long)0L, (long)arr1.size());
        long arr1Time = System.currentTimeMillis() - startTime;
        System.out.println("Standard Implementation Remove " + arr1Time + "ms");
        startTime = System.currentTimeMillis();
        int i3 = 0;
        while (i3 < 200000) {
            arr2.remove((int)(Math.random() * (double)arr2.size()));
            ++i3;
        }
        Assert.assertEquals((long)0L, (long)arr2.size());
        long arr2Time = System.currentTimeMillis() - startTime;
        System.out.println("My Implementation Remove " + arr2Time + "ms");
        Assert.assertTrue(((float)arr2Time < (float)arr1Time * 1.1f ? 1 : 0) != 0);
    }
}

