/*
 * Decompiled with CFR 0.152.
 */
package common.dataStructures;

import common.JUnitUtil;
import common.dataStructures.DeArrList;
import common.dataStructures.util.SmartIterator;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SmartIteratorTest {
    @Test
    public void testSimpleUse() {
        List<Integer> list = Arrays.asList(0, 1, 2, 3, 4, 5);
        SmartIterator<Integer> sIter = new SmartIterator<Integer>(list, () -> 0);
        int i = 0;
        while (sIter.hasNext()) {
            Assert.assertEquals((long)i++, (long)sIter.next().intValue());
        }
    }

    @Test
    public void testThrowsConcurrentModificationException() {
        DeArrList<Integer> list = new DeArrList<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5));
        SmartIterator sIter = (SmartIterator)list.iterator();
        JUnitUtil.shouldFail(() -> {
            list.add(-1);
            sIter.hasNext();
        }, ConcurrentModificationException.class);
        JUnitUtil.shouldFail(() -> {
            list.remove(0);
            sIter.hasNext();
        }, ConcurrentModificationException.class);
        JUnitUtil.shouldFail(() -> {
            list.clear();
            sIter.hasNext();
        }, ConcurrentModificationException.class);
    }

    @Test
    public void testRemove() {
        DeArrList<Integer> list = new DeArrList<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5));
        SmartIterator sIter = (SmartIterator)list.iterator();
        while (sIter.hasNext()) {
            sIter.next();
            sIter.remove();
        }
        Assert.assertTrue((boolean)list.isEmpty());
        DeArrList<Integer> list2 = new DeArrList<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5));
        SmartIterator sIter2 = (SmartIterator)list2.iterator();
        sIter2.next();
        sIter2.remove();
        JUnitUtil.shouldFail(() -> {
            list2.add(12);
            sIter2.hasNext();
        }, ConcurrentModificationException.class);
    }
}

