/*
 * Decompiled with CFR 0.152.
 */
package common.dataStructures;

import common.JUnitUtil;
import common.dataStructures.LinkedHashMap;
import common.types.Tuple2;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class LinkedHashMapTest {
    @Test
    public void testBasicHashmap() {
        LinkedHashMap<String, Integer> h = new LinkedHashMap<String, Integer>();
        Assert.assertEquals((long)0L, (long)h.size());
        h.put("A", 2);
        Assert.assertEquals((long)1L, (long)h.size());
        Assert.assertEquals((Object)new Integer(2), h.get("A"));
        Assert.assertEquals(null, h.get("B"));
        Integer o = h.put("B", 3);
        Assert.assertEquals((long)2L, (long)h.size());
        Assert.assertEquals((Object)new Integer(2), h.get("A"));
        Assert.assertEquals((Object)new Integer(3), h.get("B"));
        Assert.assertEquals(null, (Object)o);
        Integer two = h.put("A", 5);
        Assert.assertEquals((long)2L, (long)h.size());
        Assert.assertEquals((Object)new Integer(5), h.get("A"));
        Assert.assertEquals((Object)new Integer(3), h.get("B"));
        Assert.assertEquals((Object)new Integer(2), (Object)two);
        o = (Integer)h.remove("D");
        Assert.assertEquals(null, (Object)o);
        h.clear();
        Assert.assertEquals((long)h.size(), (long)0L);
        int i = 65;
        while (i < 90) {
            h.put(String.valueOf((char)i), i);
            ++i;
        }
        i = 65;
        while (i < 90) {
            Assert.assertEquals((Object)new Integer(i), h.get(String.valueOf((char)i)));
            ++i;
        }
    }

    @Test
    public void testEqualityAndHashcode() {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        Assert.assertEquals(m, m);
        Assert.assertFalse((boolean)m.equals(null));
        LinkedHashMap<String, Integer> m2 = new LinkedHashMap<String, Integer>();
        Assert.assertEquals(m, m2);
        Assert.assertEquals((long)m.hashCode(), (long)m2.hashCode());
        m.put("1", 1);
        Assert.assertFalse((boolean)m.equals(m2));
        Assert.assertFalse((boolean)m2.equals(m));
        m2.put("1", 1);
        Assert.assertEquals(m, m2);
        Assert.assertEquals((long)m.hashCode(), (long)m2.hashCode());
        m.put("2", 2);
        m2.put("3", 3);
        Assert.assertFalse((boolean)m.equals(m2));
        Assert.assertFalse((boolean)m2.equals(m));
    }

    @Test
    public void testIterators() {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        int i = 65;
        while (i < 90) {
            m.put(String.valueOf((char)i), i);
            ++i;
        }
        int n = 65;
        for (Map.Entry e : m) {
            Assert.assertEquals(e.getValue(), (Object)new Integer(n));
            Assert.assertEquals(e.getKey(), (Object)String.valueOf((char)n));
            ++n;
        }
        Iterator i2 = m.iterator();
        while (i2.hasNext()) {
            i2.remove();
            i2.next();
        }
        Assert.assertEquals((long)m.size(), (long)0L);
    }

    @Test
    public void testPutAt() {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        Assert.assertEquals((Object)"{}", (Object)m.toString());
        m.put("A", 1);
        Assert.assertEquals((Object)"{A=1}", (Object)m.toString());
        m.put("B", 2);
        Assert.assertEquals((Object)"{A=1, B=2}", (Object)m.toString());
        m.putLast("C", 2);
        Assert.assertEquals((Object)"{A=1, B=2, C=2}", (Object)m.toString());
        m.putFirst("D", 5);
        Assert.assertEquals((Object)"{D=5, A=1, B=2, C=2}", (Object)m.toString());
        m.putAt("E", 4, 1);
        Assert.assertEquals((Object)"{D=5, E=4, A=1, B=2, C=2}", (Object)m.toString());
        m.putAt("F", 6, m.size());
        Assert.assertEquals((Object)"{D=5, E=4, A=1, B=2, C=2, F=6}", (Object)m.toString());
        m.put("B", 8);
        Assert.assertEquals((Object)"{D=5, E=4, A=1, B=8, C=2, F=6}", (Object)m.toString());
        JUnitUtil.shouldFail(m::putAt, "E", 5, 2, RuntimeException.class);
    }

    @Test
    public void testAdd() {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        Assert.assertTrue((boolean)m.add(new E("1", 1)));
        Assert.assertEquals((Object)"{1=1}", (Object)m.toString());
        Assert.assertTrue((boolean)m.add(new E("3", 3)));
        Assert.assertTrue((boolean)m.add(1, new E("2", 2)));
        Assert.assertEquals((Object)"{1=1, 2=2, 3=3}", (Object)m.toString());
        LinkedList<E> ll = new LinkedList<E>();
        ll.add(new E("4", 4));
        ll.add(new E("5", 5));
        Assert.assertTrue((boolean)m.addAll(ll));
        Assert.assertEquals((Object)"{1=1, 2=2, 3=3, 4=4, 5=5}", (Object)m.toString());
        ll.clear();
        ll.add(new E("A", 10));
        ll.add(new E("B", 11));
        Assert.assertTrue((boolean)m.addAll(2, ll));
        Assert.assertEquals((Object)"{1=1, 2=2, A=10, B=11, 3=3, 4=4, 5=5}", (Object)m.toString());
        Assert.assertFalse((boolean)m.add(new E("3", 5)));
    }

    @Test
    public void testGetSet() {
        LinkedHashMap<String, Integer> m = new LinkedHashMap<String, Integer>();
        try {
            m.get(0);
            Assert.fail((String)"Got out of bounds index");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        m.put("A", 1);
        Map.Entry e = m.get(0);
        Assert.assertEquals((Object)"A", e.getKey());
        Assert.assertEquals((Object)new Integer(1), e.getValue());
        Assert.assertEquals(e, m.getFirst());
        Assert.assertEquals(e, m.getLast());
        m.put("B", 2);
        m.put("C", 3);
        Assert.assertEquals((Object)"A", m.getFirst().getKey());
        Assert.assertEquals((Object)"B", m.get(1).getKey());
        Assert.assertEquals((Object)new Integer(3), m.getLast().getValue());
    }

    private static class E
    extends Tuple2<String, Integer>
    implements Map.Entry<String, Integer> {
        public E(String first, Integer second) {
            super(first, second);
        }

        @Override
        public String getKey() {
            return (String)this._1;
        }

        @Override
        public Integer getValue() {
            return (Integer)this._2;
        }

        @Override
        public Integer setValue(Integer value) {
            throw new RuntimeException();
        }
    }
}

