/*
 * Decompiled with CFR 0.152.
 */
package common.dataStructures;

import common.JUnitUtil;
import common.dataStructures.DeArrList;
import java.util.AbstractList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;

public class DeArrListTest {
    @Test
    public void testAdd() {
        DeArrList<Integer> a = new DeArrList<Integer>(8);
        Assert.assertEquals((Object)"()", (Object)a.toString());
        Assert.assertTrue((boolean)a.isEmpty());
        a.add(1);
        Assert.assertEquals((Object)"(1)", (Object)a.toString());
        Assert.assertEquals((long)1L, (long)a.size());
        Assert.assertFalse((boolean)a.isEmpty());
        a.add(2);
        Assert.assertEquals((Object)"(1,2)", (Object)a.toString());
        Assert.assertEquals((long)2L, (long)a.size());
        a.add(3);
        Assert.assertEquals((Object)"(1,2,3)", (Object)a.toString());
        Assert.assertEquals((long)3L, (long)a.size());
        a.add(4);
        Assert.assertEquals((Object)"(1,2,3,4)", (Object)a.toString());
        Assert.assertEquals((long)4L, (long)a.size());
        a.add(5);
        Assert.assertEquals((Object)"(1,2,3,4,5)", (Object)a.toString());
        Assert.assertEquals((long)5L, (long)a.size());
        a.add(6);
        Assert.assertEquals((Object)"(1,2,3,4,5,6)", (Object)a.toString());
        Assert.assertEquals((long)6L, (long)a.size());
        a.add(7);
        Assert.assertEquals((Object)"(1,2,3,4,5,6,7)", (Object)a.toString());
        Assert.assertEquals((long)7L, (long)a.size());
        DeArrList<Integer> a2 = new DeArrList<Integer>(4);
        String s = "(";
        Assert.assertTrue((boolean)a2.isEmpty());
        int i = 0;
        while (i < 50) {
            a2.add(i);
            Assert.assertEquals((long)(i + 1), (long)a2.size());
            Assert.assertFalse((boolean)a2.isEmpty());
            s = String.valueOf(s) + i + (i < 49 ? "," : "");
            ++i;
        }
        Assert.assertEquals((Object)(String.valueOf(s) + ")"), (Object)a2.toString());
    }

    @Test
    public void testGet() {
        DeArrList<Integer> a = new DeArrList<Integer>();
        int i = 0;
        while (i < 50) {
            a.add(i);
            ++i;
        }
        i = 0;
        while (i < 50) {
            Assert.assertEquals((Object)new Integer(i), a.get(i));
            ++i;
        }
        try {
            a.get(-1);
            Assert.fail((String)"Got an out of bounds element");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            a.get(a.size());
            Assert.fail((String)"Got an out of bounds element");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testPrepend() {
        DeArrList<Integer> a = new DeArrList<Integer>();
        Assert.assertEquals((Object)"()", (Object)a.toString());
        a.push(5);
        Assert.assertEquals((Object)"(5)", (Object)a.toString());
        Assert.assertEquals((long)1L, (long)a.size());
        a.push(4);
        Assert.assertEquals((Object)"(4,5)", (Object)a.toString());
        Assert.assertEquals((long)2L, (long)a.size());
        a.push(3);
        Assert.assertEquals((Object)"(3,4,5)", (Object)a.toString());
        Assert.assertEquals((long)3L, (long)a.size());
        a.push(2);
        Assert.assertEquals((Object)"(2,3,4,5)", (Object)a.toString());
        Assert.assertEquals((long)4L, (long)a.size());
        a.push(1);
        Assert.assertEquals((Object)"(1,2,3,4,5)", (Object)a.toString());
        Assert.assertEquals((long)5L, (long)a.size());
        a.push(0);
        Assert.assertEquals((Object)"(0,1,2,3,4,5)", (Object)a.toString());
        Assert.assertEquals((long)6L, (long)a.size());
        a.push(-1);
        Assert.assertEquals((Object)"(-1,0,1,2,3,4,5)", (Object)a.toString());
        Assert.assertEquals((long)7L, (long)a.size());
        DeArrList<Integer> a2 = new DeArrList<Integer>(4);
        String s = "(";
        int i = 49;
        while (i >= 0) {
            a2.push(i);
            --i;
        }
        i = 0;
        while (i < 50) {
            s = String.valueOf(s) + i + (i < 49 ? "," : "");
            ++i;
        }
        Assert.assertEquals((Object)(String.valueOf(s) + ")"), (Object)a2.toString());
    }

    @Test
    public void testAddAt() {
        DeArrList<Integer> a = new DeArrList<Integer>(8);
        a.add(1);
        a.add(3);
        a.add(6);
        Assert.assertEquals((Object)"(1,3,6)", (Object)a.toString());
        Assert.assertEquals((long)3L, (long)a.size());
        a.add(1, 2);
        Assert.assertEquals((Object)"(1,2,3,6)", (Object)a.toString());
        Assert.assertEquals((long)4L, (long)a.size());
        a.add(3, 5);
        Assert.assertEquals((Object)"(1,2,3,5,6)", (Object)a.toString());
        Assert.assertEquals((long)5L, (long)a.size());
        a.add(1, 4);
        Assert.assertEquals((Object)"(1,4,2,3,5,6)", (Object)a.toString());
        Assert.assertEquals((long)6L, (long)a.size());
        a.add(1, 12);
        Assert.assertEquals((Object)"(1,12,4,2,3,5,6)", (Object)a.toString());
        Assert.assertEquals((long)7L, (long)a.size());
        a.add(5, 45);
        Assert.assertEquals((Object)"(1,12,4,2,3,45,5,6)", (Object)a.toString());
        Assert.assertEquals((long)8L, (long)a.size());
        a.add(0, 10);
        Assert.assertEquals((Object)"(10,1,12,4,2,3,45,5,6)", (Object)a.toString());
        Assert.assertEquals((long)9L, (long)a.size());
        a.add(9, 99);
        Assert.assertEquals((Object)"(10,1,12,4,2,3,45,5,6,99)", (Object)a.toString());
        Assert.assertEquals((long)10L, (long)a.size());
        JUnitUtil.shouldFail(a::add, Integer.valueOf(12), Integer.valueOf(3), ArrayIndexOutOfBoundsException.class);
        JUnitUtil.shouldFail(a::add, Integer.valueOf(-1), Integer.valueOf(3), ArrayIndexOutOfBoundsException.class);
        DeArrList<Integer> a2 = new DeArrList<Integer>(4);
        String s = "(";
        a2.add(0);
        a2.add(49);
        int i = 1;
        while (i < 49) {
            a2.add(i, i);
            ++i;
        }
        i = 0;
        while (i < 50) {
            s = String.valueOf(s) + i + (i < 49 ? "," : "");
            ++i;
        }
        Assert.assertEquals((Object)(String.valueOf(s) + ")"), (Object)a2.toString());
    }

    @Test
    public void testAddCollections() {
        DeArrList<Integer> a = new DeArrList<Integer>();
        a.add(1);
        a.add(2);
        a.add(3);
        a.add(4);
        Object a2 = a.clone();
        Assert.assertEquals((long)4L, (long)a.size());
        Assert.assertEquals((Object)"(1,2,3,4)", (Object)a.toString());
        a.addAll((Collection<Integer>)a2);
        Assert.assertEquals((long)8L, (long)a.size());
        Assert.assertEquals((Object)"(1,2,3,4,1,2,3,4)", (Object)a.toString());
        a.addAll(2, (Collection<Integer>)a2);
        Assert.assertEquals((long)12L, (long)a.size());
        Assert.assertEquals((Object)"(1,2,1,2,3,4,3,4,1,2,3,4)", (Object)a.toString());
    }

    @Test
    public void testEqualityAndHashcode() {
        DeArrList<Integer> a = new DeArrList<Integer>();
        Object a2 = a.clone();
        Assert.assertTrue((boolean)a.equals(a2));
        Assert.assertTrue((boolean)((AbstractList)a2).equals(a));
        Assert.assertFalse((boolean)a.equals(null));
        Assert.assertEquals((long)a.hashCode(), (long)((AbstractList)a2).hashCode());
        a.add(1);
        Assert.assertFalse((boolean)a.equals(a2));
        Assert.assertFalse((boolean)((AbstractList)a2).equals(a));
        Assert.assertFalse((boolean)a.equals(null));
        Assert.assertFalse((boolean)((AbstractList)a2).equals(null));
        ((AbstractList)a2).add(1);
        Assert.assertTrue((boolean)a.equals(a2));
        Assert.assertTrue((boolean)((AbstractList)a2).equals(a));
        Assert.assertEquals((long)a.hashCode(), (long)((AbstractList)a2).hashCode());
        a.add(2);
        ((AbstractList)a2).add(3);
        Assert.assertFalse((boolean)a.equals(a2));
        Assert.assertFalse((boolean)((AbstractList)a2).equals(a));
        Assert.assertFalse((boolean)a.equals(null));
        Assert.assertFalse((boolean)((AbstractList)a2).equals(null));
        a.removeLast();
        ((DeArrList)a2).removeLast();
        a.add(3);
        ((AbstractList)a2).add(3);
        a.rotateTo(2);
        Assert.assertTrue((boolean)a.equals(a2));
        Assert.assertTrue((boolean)((AbstractList)a2).equals(a));
        Assert.assertEquals((long)a.hashCode(), (long)((AbstractList)a2).hashCode());
    }

    @Test
    public void testSet() {
        DeArrList<Integer> a = new DeArrList<Integer>();
        a.add(1);
        a.add(2);
        a.add(3);
        a.add(4);
        a.add(5);
        Assert.assertEquals((long)5L, (long)a.size());
        Assert.assertEquals((Object)"(1,2,3,4,5)", (Object)a.toString());
        a.set(0, 11);
        Assert.assertEquals((long)5L, (long)a.size());
        Assert.assertEquals((Object)"(11,2,3,4,5)", (Object)a.toString());
        a.set(2, 31);
        Assert.assertEquals((long)5L, (long)a.size());
        Assert.assertEquals((Object)"(11,2,31,4,5)", (Object)a.toString());
        a.set(4, 51);
        Assert.assertEquals((long)5L, (long)a.size());
        Assert.assertEquals((Object)"(11,2,31,4,51)", (Object)a.toString());
        JUnitUtil.shouldFail(a::set, Integer.valueOf(-1), Integer.valueOf(2), ArrayIndexOutOfBoundsException.class);
        JUnitUtil.shouldFail(a::set, Integer.valueOf(6), Integer.valueOf(2), ArrayIndexOutOfBoundsException.class);
    }

    @Test
    public void testRotate() {
        DeArrList<String> a = new DeArrList<String>();
        int i = 0;
        while (i < 4) {
            a.add("" + i);
            ++i;
        }
        Assert.assertEquals((long)4L, (long)a.size());
        Assert.assertEquals((Object)"(0,1,2,3)", (Object)a.toString());
        i = 0;
        while (i < a.getArrLength()) {
            a.rotateTo(i);
            Assert.assertEquals((long)4L, (long)a.size());
            Assert.assertEquals((Object)"(0,1,2,3)", (Object)a.toString());
            ++i;
        }
        a = new DeArrList(4);
        i = 0;
        while (i < 4) {
            a.add("" + i);
            ++i;
        }
        Assert.assertEquals((long)4L, (long)a.size());
        Assert.assertEquals((Object)"(0,1,2,3)", (Object)a.toString());
        i = 0;
        while (i < a.getArrLength()) {
            a.rotateTo(i);
            Assert.assertEquals((long)4L, (long)a.size());
            Assert.assertEquals((Object)"(0,1,2,3)", (Object)a.toString());
            ++i;
        }
    }

    @Test
    public void testRemove() {
        DeArrList<String> a = new DeArrList<String>();
        int i = 0;
        while (i < 4) {
            a.add("" + i);
            ++i;
        }
        Assert.assertEquals((long)4L, (long)a.size());
        Assert.assertEquals((Object)"(0,1,2,3)", (Object)a.toString());
        boolean b = a.remove("1");
        Assert.assertTrue((boolean)b);
        Assert.assertEquals((long)3L, (long)a.size());
        Assert.assertEquals((Object)"(0,2,3)", (Object)a.toString());
        String s = (String)a.remove(1);
        Assert.assertEquals((Object)"2", (Object)s);
        Assert.assertEquals((long)2L, (long)a.size());
        Assert.assertEquals((Object)"(0,3)", (Object)a.toString());
        b = a.remove("3");
        Assert.assertTrue((boolean)b);
        Assert.assertEquals((long)1L, (long)a.size());
        Assert.assertEquals((Object)"(0)", (Object)a.toString());
        s = (String)a.remove(0);
        Assert.assertEquals((Object)"0", (Object)s);
        Assert.assertEquals((long)0L, (long)a.size());
        Assert.assertEquals((Object)"()", (Object)a.toString());
        a = new DeArrList(4);
        a.add("0");
        a.add("1");
        a.add("2");
        a.add("3");
        Assert.assertEquals((long)4L, (long)a.size());
        Assert.assertEquals((Object)"(0,1,2,3)", (Object)a.toString());
        int i2 = 0;
        while (i2 < 4) {
            a.rotateTo(i2);
            int k = 0;
            while (k < 4) {
                String elm = (String)a.remove(k);
                Assert.assertEquals((long)3L, (long)a.size());
                Assert.assertEquals((Object)("" + k), (Object)elm);
                a.add(k, elm);
                ++k;
            }
            ++i2;
        }
    }

    @Test
    public void testDequeFunctions() {
        DeArrList<Integer> a = new DeArrList<Integer>();
        int i = 0;
        while (i < 5) {
            a.add(i);
            ++i;
        }
        Assert.assertEquals((Object)"(0,1,2,3,4)", (Object)a.toString());
        a.offer(5);
        Assert.assertEquals((Object)"(0,1,2,3,4,5)", (Object)a.toString());
        a.offerFirst(-1);
        Assert.assertEquals((Object)"(-1,0,1,2,3,4,5)", (Object)a.toString());
        a.offerLast(6);
        Assert.assertEquals((Object)"(-1,0,1,2,3,4,5,6)", (Object)a.toString());
        a.push(-2);
        Assert.assertEquals((Object)"(-2,-1,0,1,2,3,4,5,6)", (Object)a.toString());
        Assert.assertEquals((Object)new Integer(-2), a.peek());
        Assert.assertEquals((Object)new Integer(-2), a.peekFirst());
        Assert.assertEquals((Object)new Integer(-2), a.element());
        Assert.assertEquals((Object)new Integer(6), a.peekLast());
        Integer i2 = (Integer)a.poll();
        Assert.assertEquals((Object)new Integer(-2), (Object)i2);
        Assert.assertEquals((Object)"(-1,0,1,2,3,4,5,6)", (Object)a.toString());
        i2 = (Integer)a.pollFirst();
        Assert.assertEquals((Object)new Integer(-1), (Object)i2);
        Assert.assertEquals((Object)"(0,1,2,3,4,5,6)", (Object)a.toString());
        i2 = (Integer)a.pollLast();
        Assert.assertEquals((Object)new Integer(6), (Object)i2);
        Assert.assertEquals((Object)"(0,1,2,3,4,5)", (Object)a.toString());
        i2 = (Integer)a.pop();
        Assert.assertEquals((Object)new Integer(0), (Object)i2);
        Assert.assertEquals((Object)"(1,2,3,4,5)", (Object)a.toString());
        a.addFirst(0);
        Assert.assertEquals((Object)"(0,1,2,3,4,5)", (Object)a.toString());
        a.addLast(6);
        Assert.assertEquals((Object)"(0,1,2,3,4,5,6)", (Object)a.toString());
        Assert.assertEquals((Object)new Integer(0), a.getFirst());
        Assert.assertEquals((Object)new Integer(6), a.getLast());
        i2 = (Integer)a.removeFirst();
        Assert.assertEquals((Object)new Integer(0), (Object)i2);
        Assert.assertEquals((Object)"(1,2,3,4,5,6)", (Object)a.toString());
        i2 = (Integer)a.removeLast();
        Assert.assertEquals((Object)new Integer(6), (Object)i2);
        Assert.assertEquals((Object)"(1,2,3,4,5)", (Object)a.toString());
        a.add(1);
        boolean ok = a.removeFirstOccurrence(1);
        Assert.assertTrue((boolean)ok);
        Assert.assertEquals((Object)"(2,3,4,5,1)", (Object)a.toString());
        a.push(1);
        ok = a.removeLastOccurrence(1);
        Assert.assertTrue((boolean)ok);
        Assert.assertEquals((Object)"(1,2,3,4,5)", (Object)a.toString());
        ok = a.removeFirstOccurrence(7);
        Assert.assertFalse((boolean)ok);
        ok = a.removeLastOccurrence(19);
        Assert.assertFalse((boolean)ok);
        a.clear();
        Assert.assertEquals(null, a.peek());
        Assert.assertEquals(null, a.peekFirst());
        Assert.assertEquals(null, a.peekLast());
        Assert.assertEquals(null, a.poll());
        Assert.assertEquals(null, a.pollFirst());
        Assert.assertEquals(null, a.pollLast());
        JUnitUtil.shouldFail(a::getFirst, ArrayIndexOutOfBoundsException.class);
        JUnitUtil.shouldFail(a::getLast, ArrayIndexOutOfBoundsException.class);
        JUnitUtil.shouldFail(a::removeFirst, ArrayIndexOutOfBoundsException.class);
        JUnitUtil.shouldFail(a::removeLast, ArrayIndexOutOfBoundsException.class);
    }
}

