/*
 * Decompiled with CFR 0.152.
 */
package common.dataStructures;

import common.Util;
import common.dataStructures.util.SmartIterator;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;

public class DeArrList<E>
extends AbstractList<E>
implements Cloneable,
Deque<E> {
    private int start;
    private int end;
    private int size;
    private Object[] vals;
    static final int DEFAULT_SIZE = 16;

    public DeArrList() {
        this(16);
    }

    public DeArrList(Collection<? extends E> c) {
        this(Math.max(16, c.size()));
        this.addAll(c);
    }

    public DeArrList(int size) {
        this.vals = new Object[size];
        this.start = size / 4;
        this.end = size / 4;
    }

    public DeArrList<E> clone() {
        return new DeArrList<E>(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    int getStart() {
        return this.start;
    }

    int getEnd() {
        return this.end;
    }

    int getArrLength() {
        return this.vals.length;
    }

    void rotateTo(int newStart) {
        if (newStart < 0 || newStart >= this.vals.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (newStart == this.start) {
            return;
        }
        Object[] arr = new Object[this.vals.length];
        int portion1 = Math.min(this.size, Math.min(this.vals.length - this.start, this.vals.length - newStart));
        System.arraycopy(this.vals, this.start, arr, newStart, portion1);
        int portion2 = Math.min(this.size - portion1, Math.abs(this.start - newStart));
        if (portion2 > 0) {
            System.arraycopy(this.vals, Util.mod(this.start + portion1, this.vals.length), arr, Util.mod(newStart + portion1, arr.length), portion2);
            int portion3 = this.size - portion1 - portion2;
            if (portion3 > 0) {
                System.arraycopy(this.vals, Util.mod(this.start + portion1 + portion2, this.vals.length), arr, Util.mod(newStart + portion1 + portion2, arr.length), portion3);
            }
        }
        this.start = newStart;
        this.end = Util.mod(newStart + this.size, arr.length);
        this.vals = arr;
    }

    @Override
    public String toString() {
        if (this.size() == 0) {
            return "()";
        }
        String s = "(";
        for (E e : this) {
            s = String.valueOf(s) + e + ",";
        }
        return String.valueOf(s.substring(0, s.length() - 1)) + ")";
    }

    private boolean reArray() {
        if (this.size() >= this.vals.length) {
            Object[] oArr = new Object[this.vals.length * 2];
            if (this.start < this.end) {
                System.arraycopy(this.vals, this.start, oArr, this.vals.length / 2, this.end - this.start);
            } else {
                System.arraycopy(this.vals, this.start, oArr, this.vals.length / 2, this.vals.length - this.start);
                System.arraycopy(this.vals, 0, oArr, this.vals.length / 2 + (this.vals.length - this.start), this.end);
            }
            this.start = this.vals.length / 2;
            this.end = this.vals.length * 3 / 2;
            this.vals = oArr;
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, E element) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.reArray();
        int realIndex = Util.mod(this.start + index, this.vals.length);
        if (index == this.size()) {
            this.end = Util.mod(this.end + 1, this.vals.length);
            this.vals[Util.mod((int)realIndex, (int)this.vals.length)] = element;
        } else if (index == 0) {
            this.start = Util.mod(this.start - 1, this.vals.length);
            this.vals[Util.mod((int)(realIndex - 1), (int)this.vals.length)] = element;
        } else if (this.end == this.vals.length || this.start != 0 && (this.start < this.end && index < this.size() / 2 || this.start > this.end && this.start < realIndex)) {
            System.arraycopy(this.vals, this.start, this.vals, this.start - 1, index);
            this.start = Util.mod(this.start - 1, this.vals.length);
            this.vals[Util.mod((int)(realIndex - 1), (int)this.vals.length)] = element;
        } else {
            System.arraycopy(this.vals, realIndex, this.vals, realIndex + 1, this.size() - index);
            this.end = Util.mod(this.end + 1, this.vals.length);
            this.vals[Util.mod((int)realIndex, (int)this.vals.length)] = element;
        }
        ++this.size;
        ++this.modCount;
    }

    @Override
    public void push(E e) {
        this.add(0, e);
    }

    @Override
    public boolean offer(E e) {
        this.add(e);
        return true;
    }

    @Override
    public void addFirst(E e) {
        this.add(0, e);
    }

    @Override
    public void addLast(E e) {
        this.add(e);
    }

    @Override
    public boolean offerFirst(E e) {
        this.add(0, e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.add(e);
        return true;
    }

    @Override
    public E get(int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object e = this.vals[Util.mod(index + this.start, this.vals.length)];
        return (E)e;
    }

    @Override
    public E element() throws ArrayIndexOutOfBoundsException {
        return this.get(0);
    }

    @Override
    public E getFirst() throws ArrayIndexOutOfBoundsException {
        return this.get(0);
    }

    @Override
    public E getLast() throws ArrayIndexOutOfBoundsException {
        return this.get(this.size() - 1);
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public E peekFirst() {
        try {
            return this.get(0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public E peekLast() {
        try {
            return this.get(this.size() - 1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public E set(int index, E element) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        E prev = this.get(index);
        this.vals[Util.mod((int)(index + this.start), (int)this.vals.length)] = element;
        return prev;
    }

    @Override
    public E remove(int index) throws ArrayIndexOutOfBoundsException {
        E e = this.get(index);
        if (index == this.size() - 1) {
            this.vals[Util.mod((int)(this.end - 1), (int)this.vals.length)] = null;
            this.end = Util.mod(this.end - 1, this.vals.length);
        } else if (index == 0) {
            this.vals[this.start] = null;
            this.start = Util.mod(this.start + 1, this.vals.length);
        } else {
            int realIndex = Util.mod(this.start + index, this.vals.length);
            if (this.start < this.end && index < this.size() / 2 || this.start >= this.end && this.start < realIndex) {
                System.arraycopy(this.vals, this.start, this.vals, this.start + 1, realIndex - this.start);
                this.vals[this.start] = null;
                this.start = Util.mod(this.start + 1, this.vals.length);
            } else {
                System.arraycopy(this.vals, realIndex + 1, this.vals, realIndex, this.end - realIndex - 1);
                this.vals[this.end - 1] = null;
                this.end = Util.mod(this.end - 1, this.vals.length);
            }
        }
        --this.size;
        ++this.modCount;
        return e;
    }

    @Override
    public E poll() {
        try {
            return this.remove(0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public E pop() throws ArrayIndexOutOfBoundsException {
        return this.removeFirst();
    }

    @Override
    public E remove() throws ArrayIndexOutOfBoundsException {
        return this.removeFirst();
    }

    @Override
    public void clear() {
        this.vals = new Object[this.vals.length];
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public E removeFirst() throws ArrayIndexOutOfBoundsException {
        return this.remove(0);
    }

    @Override
    public E removeLast() throws ArrayIndexOutOfBoundsException {
        return this.remove(this.size() - 1);
    }

    @Override
    public E pollFirst() {
        try {
            return this.remove(0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public E pollLast() {
        try {
            return this.remove(this.size() - 1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        try {
            return this.remove(this.indexOf(o)) != null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        try {
            return this.remove(this.lastIndexOf(o)) != null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new SmartIterator(super.iterator(), () -> this.modCount);
    }

    @Override
    public Iterator<E> descendingIterator() {
        throw new UnsupportedOperationException("Not Yet Implemented");
    }
}

