/*
 * Decompiled with CFR 0.152.
 */
package common.dataStructures;

import common.dataStructures.ConsList;
import java.util.ArrayList;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConsTest {
    private ConsList<Integer> lst;

    @Before
    public void setup() {
        this.lst = new ConsList();
    }

    @Test
    public void testConstruction() {
        Assert.assertEquals((Object)"(_NIL_)", (Object)this.lst.toString());
        Assert.assertEquals((long)0L, (long)this.lst.size);
        Assert.assertEquals(null, this.lst.tail());
        Assert.assertEquals(null, this.lst.val);
        ConsList<Integer> lst2 = this.lst.cons(1);
        Assert.assertEquals((Object)"(1)", (Object)lst2.toString());
        Assert.assertEquals((long)1L, (long)lst2.size);
        Assert.assertEquals((Object)new Integer(1), lst2.val);
        Assert.assertEquals(this.lst, lst2.tail());
        ConsList<Integer> lst3 = lst2.cons(2);
        Assert.assertEquals((Object)"(2,1)", (Object)lst3.toString());
        Assert.assertEquals((long)2L, (long)lst3.size);
        Assert.assertEquals((Object)new Integer(2), lst3.val);
        Assert.assertEquals(lst2, lst3.tail());
        Assert.assertEquals((Object)"(1)", (Object)lst2.toString());
        Assert.assertEquals((long)1L, (long)lst2.size);
        Assert.assertEquals((Object)new Integer(1), lst2.val);
        Assert.assertEquals(this.lst, lst2.tail());
        ConsList<Integer> lst4 = lst2.cons(3);
        Assert.assertEquals((Object)"(3,1)", (Object)lst4.toString());
        Assert.assertEquals((long)2L, (long)lst4.size);
        Assert.assertEquals((Object)new Integer(3), lst4.val);
        Assert.assertEquals(lst2, lst4.tail());
        Assert.assertEquals((Object)"(2,1)", (Object)lst3.toString());
        Assert.assertEquals((long)2L, (long)lst3.size);
        Assert.assertEquals((Object)new Integer(2), lst3.val);
        Assert.assertEquals(lst2, lst3.tail());
    }

    @Test
    public void testEquality() {
        Assert.assertTrue((boolean)this.lst.equals(this.lst));
        ConsList<Integer> lst2 = this.lst.cons(1);
        Assert.assertFalse((boolean)lst2.equals(this.lst));
        Assert.assertFalse((boolean)this.lst.equals(lst2));
        ConsList<Integer> lst2Clone = lst2;
        Assert.assertTrue((boolean)lst2.equals(lst2Clone));
        Assert.assertTrue((boolean)lst2Clone.equals(lst2));
        ConsList<Integer> lst3 = this.lst.cons(2);
        Assert.assertFalse((boolean)lst3.equals(lst2));
        Assert.assertFalse((boolean)lst2.equals(lst3));
        ConsList<Integer> lst4 = this.lst.cons(1);
        Assert.assertTrue((boolean)lst4.equals(lst2));
        Assert.assertTrue((boolean)lst2.equals(lst4));
        ConsList<Integer> lst22 = lst2.cons(2);
        ConsList<Integer> lst42 = lst4.cons(2);
        Assert.assertTrue((boolean)lst22.equals(lst42));
        Assert.assertTrue((boolean)lst42.equals(lst22));
        Assert.assertFalse((boolean)lst22.equals(this.lst));
        Assert.assertFalse((boolean)this.lst.equals(lst22));
    }

    @Test
    public void testListFuncs() {
        this.lst = this.lst.cons(5).cons(4).cons(3).cons(2).cons(1);
        Assert.assertEquals((Object)"(1,2,3,4,5)", (Object)this.lst.toString());
        Assert.assertFalse((boolean)this.lst.isNil());
        Assert.assertFalse((boolean)this.lst.tail().isNil());
        Assert.assertFalse((boolean)this.lst.tail().tail().isNil());
        Assert.assertFalse((boolean)this.lst.tail().tail().tail().isNil());
        Assert.assertFalse((boolean)this.lst.tail().tail().tail().tail().isNil());
        Assert.assertTrue((boolean)this.lst.tail().tail().tail().tail().tail().isNil());
        Assert.assertFalse((boolean)this.lst.isLast());
        Assert.assertFalse((boolean)this.lst.tail().isLast());
        Assert.assertFalse((boolean)this.lst.tail().tail().isLast());
        Assert.assertFalse((boolean)this.lst.tail().tail().tail().isLast());
        Assert.assertTrue((boolean)this.lst.tail().tail().tail().tail().isLast());
        Assert.assertTrue((boolean)this.lst.tail().tail().tail().tail().tail().isLast());
        Assert.assertEquals((long)5L, (long)this.lst.size());
        Assert.assertEquals((long)4L, (long)this.lst.tail().size());
        Assert.assertEquals((long)3L, (long)this.lst.tail().tail().size());
        Assert.assertEquals((long)2L, (long)this.lst.tail().tail().tail().size());
        Assert.assertEquals((long)1L, (long)this.lst.tail().tail().tail().tail().size());
        Assert.assertEquals((long)0L, (long)this.lst.tail().tail().tail().tail().tail().size());
        Assert.assertFalse((boolean)this.lst.isEmpty());
        Assert.assertFalse((boolean)this.lst.tail().isEmpty());
        Assert.assertFalse((boolean)this.lst.tail().tail().isEmpty());
        Assert.assertFalse((boolean)this.lst.tail().tail().tail().isEmpty());
        Assert.assertFalse((boolean)this.lst.tail().tail().tail().tail().isEmpty());
        Assert.assertTrue((boolean)this.lst.tail().tail().tail().tail().tail().isEmpty());
        Assert.assertTrue((boolean)this.lst.contains(1));
        Assert.assertTrue((boolean)this.lst.contains(2));
        Assert.assertTrue((boolean)this.lst.contains(3));
        Assert.assertTrue((boolean)this.lst.contains(4));
        Assert.assertTrue((boolean)this.lst.contains(5));
        Assert.assertFalse((boolean)this.lst.contains(6));
        Assert.assertFalse((boolean)this.lst.contains(null));
        Assert.assertFalse((boolean)this.lst.tail().contains(1));
        Assert.assertTrue((boolean)this.lst.tail().contains(2));
        Assert.assertTrue((boolean)this.lst.tail().contains(3));
        Assert.assertTrue((boolean)this.lst.tail().contains(4));
        Assert.assertTrue((boolean)this.lst.tail().contains(5));
        Assert.assertFalse((boolean)this.lst.tail().contains(6));
        Assert.assertFalse((boolean)this.lst.tail().contains(null));
        Assert.assertFalse((boolean)this.lst.tail().tail().tail().tail().tail().contains(null));
        ArrayList<Integer> a = new ArrayList<Integer>();
        int i = 1;
        while (i <= 5) {
            a.add(i);
            ++i;
        }
        Assert.assertTrue((boolean)this.lst.containsAll(a));
        Assert.assertFalse((boolean)this.lst.tail().containsAll(a));
        a.remove(0);
        Assert.assertTrue((boolean)this.lst.containsAll(a));
        Assert.assertTrue((boolean)this.lst.tail().containsAll(a));
        Assert.assertFalse((boolean)this.lst.tail().tail().containsAll(a));
        i = 0;
        while (i < 5) {
            Assert.assertEquals((Object)new Integer(i + 1), (Object)this.lst.get(i));
            Assert.assertEquals((long)i, (long)this.lst.indexOf(new Integer(i + 1)));
            ++i;
        }
        i = 0;
        while (i < 4) {
            Assert.assertEquals((Object)new Integer(i + 2), (Object)this.lst.tail().get(i));
            Assert.assertEquals((long)i, (long)this.lst.tail().indexOf(new Integer(i + 2)));
            ++i;
        }
    }

    @Test
    public void testIteratorsAndArrayConversion() {
        Assert.assertEquals((long)0L, (long)this.lst.toArray().length);
        this.lst = this.lst.cons(5).cons(4).cons(3).cons(2).cons(1);
        Assert.assertEquals((Object)"(1,2,3,4,5)", (Object)this.lst.toString());
        Object[] correctArr = new Object[]{1, 2, 3, 4, 5};
        Object[] arr = this.lst.toArray();
        Assert.assertEquals((long)correctArr.length, (long)arr.length);
        int i = 0;
        while (i < arr.length) {
            Assert.assertEquals((Object)correctArr[i], (Object)arr[i]);
            ++i;
        }
        Integer[] arr2 = this.lst.toArray(new Integer[0]);
        Assert.assertEquals((long)correctArr.length, (long)arr2.length);
        int i2 = 0;
        while (i2 < correctArr.length) {
            Assert.assertEquals((Object)correctArr[i2], (Object)arr2[i2]);
            ++i2;
        }
        arr2 = this.lst.toArray(new Integer[999]);
        Assert.assertEquals((long)999L, (long)arr2.length);
        i2 = 0;
        while (i2 < correctArr.length) {
            Assert.assertEquals((Object)correctArr[i2], (Object)arr2[i2]);
            ++i2;
        }
        Iterator<Integer> iterator = this.lst.iterator();
        int i3 = 1;
        while (i3 <= 5) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)new Integer(i3), (Object)iterator.next());
            ++i3;
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.lst.tail().iterator();
        i3 = 2;
        while (i3 <= 5) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)new Integer(i3), (Object)iterator.next());
            ++i3;
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = this.lst.tail().tail().tail().tail().tail().iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testReverse() {
        this.lst = this.lst.cons(5).cons(4).cons(3).cons(2).cons(1).cons(0);
        ConsList<Integer> lst2 = new ConsList<Integer>().cons(5).cons(4).cons(3).cons(2).cons(1).cons(0);
        Assert.assertEquals((Object)"(0,1,2,3,4,5)", (Object)this.lst.toString());
        Assert.assertTrue((boolean)this.lst.equals(lst2));
        this.lst = this.lst.reverse();
        Assert.assertFalse((boolean)lst2.equals(this.lst));
        Assert.assertEquals((Object)"(5,4,3,2,1,0)", (Object)this.lst.toString());
        Assert.assertEquals((long)6L, (long)this.lst.size);
        Assert.assertEquals((long)5L, (long)this.lst.tail().size);
        Assert.assertEquals((long)4L, (long)this.lst.tail().tail().size);
        Assert.assertEquals((long)3L, (long)this.lst.tail().tail().tail().size);
        Assert.assertEquals((long)2L, (long)this.lst.tail().tail().tail().tail().size);
        Assert.assertEquals((long)1L, (long)this.lst.tail().tail().tail().tail().tail().size);
        Assert.assertEquals((long)0L, (long)this.lst.tail().tail().tail().tail().tail().tail().size);
        this.lst = this.lst.reverse();
        Assert.assertEquals((Object)"(0,1,2,3,4,5)", (Object)this.lst.toString());
        Assert.assertEquals((long)6L, (long)this.lst.size);
        Assert.assertEquals((long)5L, (long)this.lst.tail().size);
        Assert.assertEquals((long)4L, (long)this.lst.tail().tail().size);
        Assert.assertEquals((long)3L, (long)this.lst.tail().tail().tail().size);
        Assert.assertEquals((long)2L, (long)this.lst.tail().tail().tail().tail().size);
        Assert.assertEquals((long)1L, (long)this.lst.tail().tail().tail().tail().tail().size);
        Assert.assertEquals((long)0L, (long)this.lst.tail().tail().tail().tail().tail().tail().size);
        Assert.assertEquals(lst2, this.lst);
    }
}

