/*
 * Decompiled with CFR 0.152.
 */
package common.dataStructures;

import common.JUnitUtil;
import common.dataStructures.BiMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class BiMapTest {
    @Test
    public void testConstruction() {
        BiMap<Character, Integer> b = new BiMap<Character, Integer>();
        Assert.assertEquals((long)0L, (long)b.size());
        b.put(Character.valueOf('a'), 0);
        Assert.assertTrue((boolean)b.containsKey(Character.valueOf('a')));
        Assert.assertFalse((boolean)b.containsKey(Character.valueOf('b')));
        Assert.assertTrue((boolean)b.containsValue(0));
        Assert.assertFalse((boolean)b.containsValue(1));
        Assert.assertFalse((boolean)b.containsKey(0));
        Assert.assertFalse((boolean)b.containsValue(Character.valueOf('a')));
        Assert.assertEquals((long)1L, (long)b.size());
        b.put(Character.valueOf('b'), 1);
        Assert.assertTrue((boolean)b.containsKey(Character.valueOf('a')));
        Assert.assertTrue((boolean)b.containsKey(Character.valueOf('b')));
        Assert.assertTrue((boolean)b.containsValue(0));
        Assert.assertTrue((boolean)b.containsValue(1));
        Assert.assertFalse((boolean)b.containsKey(0));
        Assert.assertFalse((boolean)b.containsValue(Character.valueOf('a')));
        Assert.assertEquals((long)2L, (long)b.size());
        b.put(Character.valueOf('a'), 2);
        Assert.assertTrue((boolean)b.containsKey(Character.valueOf('a')));
        Assert.assertTrue((boolean)b.containsKey(Character.valueOf('b')));
        Assert.assertFalse((boolean)b.containsValue(0));
        Assert.assertTrue((boolean)b.containsValue(1));
        Assert.assertTrue((boolean)b.containsValue(2));
        Assert.assertFalse((boolean)b.containsKey(0));
        Assert.assertFalse((boolean)b.containsValue(Character.valueOf('a')));
        Assert.assertEquals((long)2L, (long)b.size());
        b.put(Character.valueOf('c'), 1);
        Assert.assertTrue((boolean)b.containsKey(Character.valueOf('a')));
        Assert.assertFalse((boolean)b.containsKey(Character.valueOf('b')));
        Assert.assertTrue((boolean)b.containsKey(Character.valueOf('c')));
        Assert.assertFalse((boolean)b.containsValue(0));
        Assert.assertTrue((boolean)b.containsValue(1));
        Assert.assertTrue((boolean)b.containsValue(2));
        Assert.assertFalse((boolean)b.containsKey(0));
        Assert.assertFalse((boolean)b.containsValue(Character.valueOf('a')));
        Assert.assertEquals((long)2L, (long)b.size());
    }

    @Test
    public void testGetPut() {
        BiMap<Character, Integer> b = new BiMap<Character, Integer>();
        Assert.assertEquals(null, b.get(Character.valueOf('a')));
        Assert.assertEquals(null, b.getValue(Character.valueOf('a')));
        Assert.assertEquals(null, b.getKey(1));
        Integer old = b.put(Character.valueOf('a'), 1);
        Assert.assertEquals(null, (Object)old);
        Assert.assertEquals((Object)new Integer(1), b.get(Character.valueOf('a')));
        Assert.assertEquals((Object)new Integer(1), b.getValue(Character.valueOf('a')));
        Assert.assertEquals((Object)new Character('a'), b.getKey(1));
        old = b.put(Character.valueOf('b'), 1);
        Assert.assertEquals(null, (Object)old);
        Assert.assertEquals(null, b.get(Character.valueOf('a')));
        Assert.assertEquals(null, b.getValue(Character.valueOf('a')));
        Assert.assertEquals((Object)new Integer(1), b.get(Character.valueOf('b')));
        Assert.assertEquals((Object)new Integer(1), b.getValue(Character.valueOf('b')));
        Assert.assertEquals((Object)new Character('b'), b.getKey(1));
        old = (Integer)b.remove(Character.valueOf('b'));
        Assert.assertEquals((Object)new Integer(1), (Object)old);
        Assert.assertEquals((long)0L, (long)b.size());
        Assert.assertEquals(null, b.get(Character.valueOf('a')));
        Assert.assertEquals(null, b.getValue(Character.valueOf('a')));
        Assert.assertEquals(null, b.get(Character.valueOf('b')));
        Assert.assertEquals(null, b.getValue(Character.valueOf('b')));
        Assert.assertEquals(null, b.getKey(1));
    }

    @Test
    public void testEqualityHashcode() {
        BiMap<String, Integer> b = new BiMap<String, Integer>();
        Assert.assertEquals(b, b);
        Assert.assertEquals((long)b.hashCode(), (long)b.hashCode());
        Assert.assertFalse((boolean)b.equals(null));
        BiMap<String, Integer> b2 = new BiMap<String, Integer>();
        Assert.assertEquals(b, b2);
        Assert.assertEquals((long)b.hashCode(), (long)b2.hashCode());
        b.put("1", 1);
        Assert.assertFalse((boolean)b.equals(b2));
        Assert.assertFalse((boolean)b2.equals(b));
        b2.put("2", 1);
        Assert.assertFalse((boolean)b.equals(b2));
        Assert.assertFalse((boolean)b2.equals(b));
        b.put("2", 1);
        Assert.assertEquals(b, b2);
        Assert.assertEquals((long)b.hashCode(), (long)b2.hashCode());
    }

    @Test
    public void testViews() {
        BiMap<String, Integer> b = new BiMap<String, Integer>();
        HashSet<String> keys = new HashSet<String>();
        HashSet<Integer> vals = new HashSet<Integer>();
        b.put("A", 2);
        b.put("B", 3);
        b.put("C", 4);
        keys.add("A");
        keys.add("B");
        keys.add("C");
        Assert.assertEquals((long)b.keySet().size(), (long)keys.size());
        Assert.assertEquals(b.keySet(), keys);
        b.keySet().remove("A");
        keys.remove("A");
        Assert.assertEquals((long)b.keySet().size(), (long)keys.size());
        Assert.assertEquals(b.keySet(), keys);
        JUnitUtil.shouldFail(b.keySet()::add, "F", UnsupportedOperationException.class);
        b.keySet().clear();
        keys.clear();
        Assert.assertEquals((long)b.keySet().size(), (long)keys.size());
        Assert.assertEquals(b.keySet(), keys);
        b.put("A", 1);
        b.put("B", 3);
        b.put("C", 4);
        b.put("D", 5);
        b.put("E", 7);
        Iterator keyIterator = b.keySet().iterator();
        while (keyIterator.hasNext()) {
            String s = (String)keyIterator.next();
            if (s.equals("B")) {
                keyIterator.remove();
            }
            if (!s.equals("C")) continue;
            keyIterator.remove();
            keyIterator.remove();
        }
        Assert.assertEquals((long)b.size(), (long)b.keySet().size());
        Assert.assertEquals((long)3L, (long)b.keySet().size());
        BiMap<String, Integer> b2 = new BiMap<String, Integer>();
        b2.put("A", 1);
        b2.put("D", 5);
        b2.put("E", 7);
        Assert.assertEquals(b, b2);
        b.clear();
        keys.clear();
        vals.clear();
        b.put("A", 2);
        b.put("B", 3);
        b.put("C", 4);
        vals.add(2);
        vals.add(3);
        vals.add(4);
        Assert.assertEquals((long)b.values().size(), (long)vals.size());
        Assert.assertEquals((Object)b.values(), vals);
        b.values().remove(2);
        vals.remove(new Integer(2));
        Assert.assertEquals((long)b.values().size(), (long)vals.size());
        Assert.assertEquals((Object)b.values(), vals);
        JUnitUtil.shouldFail(((Set)b.values())::add, Integer.valueOf(7), UnsupportedOperationException.class);
        b.values().clear();
        vals.clear();
        Assert.assertEquals((long)b.values().size(), (long)vals.size());
        Assert.assertEquals((Object)b.values(), vals);
        b.put("A", 1);
        b.put("B", 3);
        b.put("C", 4);
        b.put("D", 5);
        b.put("E", 7);
        Iterator valuesIterator = b.values().iterator();
        while (valuesIterator.hasNext()) {
            Integer n = (Integer)valuesIterator.next();
            if (n.equals(3)) {
                valuesIterator.remove();
            }
            if (!n.equals(4)) continue;
            valuesIterator.remove();
            valuesIterator.remove();
        }
        vals.add(1);
        vals.add(5);
        vals.add(7);
        b2.put("A", 1);
        b2.put("D", 5);
        b2.put("E", 7);
        Assert.assertEquals((long)b.values().size(), (long)vals.size());
        Assert.assertEquals((Object)b.values(), vals);
        Assert.assertEquals(b, b2);
        b.clear();
        keys.clear();
        vals.clear();
        b.put("A", 2);
        b.put("B", 3);
        b.put("C", 4);
        keys.add("A");
        keys.add("B");
        keys.add("C");
        vals.add(2);
        vals.add(3);
        vals.add(4);
        Assert.assertEquals((long)b.entrySet().size(), (long)keys.size());
        Assert.assertEquals((long)b.entrySetFlipped().size(), (long)vals.size());
        for (Map.Entry entry : b.entrySet()) {
            Assert.assertTrue((boolean)keys.contains(entry.getKey()));
            Assert.assertTrue((boolean)vals.contains(entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : b.entrySetFlipped()) {
            Assert.assertTrue((boolean)keys.contains(entry.getValue()));
            Assert.assertTrue((boolean)vals.contains(entry.getKey()));
        }
        b.entrySet().clear();
        keys.clear();
        Assert.assertEquals((long)b.entrySet().size(), (long)keys.size());
        Assert.assertEquals((long)b.entrySet().size(), (long)b.entrySetFlipped().size());
        b.put("A", 1);
        b.entrySetFlipped().clear();
        vals.clear();
        Assert.assertEquals((long)b.entrySetFlipped().size(), (long)vals.size());
        Assert.assertEquals((long)b.entrySet().size(), (long)b.entrySetFlipped().size());
        b.put("A", 1);
        b.put("B", 3);
        b.put("C", 4);
        b.put("D", 5);
        b.put("E", 7);
        Iterator iterator = b.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            if (((String)e.getKey()).equals("B")) {
                iterator.remove();
            }
            if (((String)e.getKey()).equals("C")) {
                iterator.remove();
                iterator.remove();
            }
            JUnitUtil.shouldFail(e::setValue, Integer.valueOf(999), UnsupportedOperationException.class);
        }
        Assert.assertEquals((long)b.size(), (long)b.keySet().size());
        Assert.assertEquals((long)3L, (long)b.keySet().size());
        b2.clear();
        b2.put("A", 1);
        b2.put("D", 5);
        b2.put("E", 7);
        Assert.assertEquals(b, b2);
        Iterator rentriesIterator = b.entrySetFlipped().iterator();
        while (rentriesIterator.hasNext()) {
            Map.Entry e = rentriesIterator.next();
            if (((Integer)e.getKey()).equals(1)) {
                rentriesIterator.remove();
            }
            if (((Integer)e.getKey()).equals(5)) {
                rentriesIterator.remove();
                rentriesIterator.remove();
            }
            JUnitUtil.shouldFail(e::setValue, "VAL", UnsupportedOperationException.class);
        }
        b2.remove("A");
        b2.remove("D");
        Assert.assertEquals(b, b2);
    }
}

