/*
 * Decompiled with CFR 0.152.
 */
package common.dataStructures;

import common.dataStructures.util.SmartIterator;
import common.dataStructures.util.UnmodifiableEntry;
import common.dataStructures.util.ViewIterator;
import common.dataStructures.util.ViewSet;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BiMap<K, V>
extends AbstractMap<K, V>
implements Cloneable,
Map<K, V> {
    private HashMap<K, V> forwardMap = new HashMap();
    private HashMap<V, K> backMap = new HashMap();
    private Set<K> keySet = new KeySet();
    private Set<V> valueSet = new ValueSet();
    private Set<Map.Entry<K, V>> entrySet = new EntrySet();
    private Set<Map.Entry<V, K>> rEntrySet = new REntrySet();
    protected int modCount = 0;

    @Override
    public BiMap<K, V> clone() {
        BiMap<K, V> b = new BiMap<K, V>();
        b.putAll(this);
        return b;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        try {
            BiMap b = (BiMap)o;
            return this.entrySet().equals(b.entrySet());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public BiMap<V, K> flip() {
        BiMap<K, V> b = new BiMap<K, V>();
        b.backMap.putAll(this.forwardMap);
        b.forwardMap.putAll(this.backMap);
        return b;
    }

    public Map<K, V> toMap() {
        return new HashMap<K, V>(this.forwardMap);
    }

    public Map<V, K> toFlippedMap() {
        return new HashMap<V, K>(this.backMap);
    }

    @Override
    public int size() {
        return this.forwardMap.size();
    }

    @Override
    public V put(K k, V v) {
        if (k == null || v == null) {
            throw new IllegalArgumentException("Null keys or values aren't valid in a BiMap");
        }
        V old = this.forwardMap.put(k, v);
        K old2 = this.backMap.put(v, k);
        if (old2 != null && !old2.equals(k)) {
            this.forwardMap.remove(old2);
        }
        if (old != null && !old.equals(v)) {
            this.backMap.remove(old);
        }
        ++this.modCount;
        return old;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m instanceof BiMap) {
            super.putAll(m);
            return;
        }
        HashSet<V> vals = new HashSet<V>(m.values());
        if (vals.size() != m.values().size()) {
            throw new IllegalArgumentException("Can't add " + m + " to " + this + ":" + "Values contain duplicates, would have unspecified performance");
        }
        super.putAll(m);
    }

    @Override
    public boolean containsValue(Object v) {
        return this.backMap.containsKey(v);
    }

    @Override
    public boolean containsKey(Object k) {
        return this.forwardMap.containsKey(k);
    }

    @Override
    public V get(Object key) {
        return this.forwardMap.get(key);
    }

    @Override
    public V getOrDefault(Object key, V defaultV) {
        V v = this.get(key);
        return v != null ? v : defaultV;
    }

    public V getValue(K key) {
        return this.get(key);
    }

    public V getValueOrDefault(K key, V defaultV) {
        return this.getOrDefault(key, defaultV);
    }

    public K getKey(V value) {
        return this.backMap.get(value);
    }

    public K getKeyOrDefault(V value, K defaultK) {
        K k = this.getKey(value);
        return k != null ? k : defaultK;
    }

    @Override
    public V remove(Object key) {
        V v = this.forwardMap.remove(key);
        if (v != null) {
            this.backMap.remove(v);
        }
        ++this.modCount;
        return v;
    }

    public V removeKey(K key) {
        return this.remove(key);
    }

    public K removeValue(V value) {
        K k = this.backMap.remove(value);
        if (k != null) {
            this.forwardMap.remove(k);
        }
        ++this.modCount;
        return k;
    }

    @Override
    public void clear() {
        this.forwardMap.clear();
        this.backMap.clear();
        ++this.modCount;
    }

    @Override
    public Set<K> keySet() {
        return this.keySet;
    }

    @Override
    public Set<V> values() {
        return this.valueSet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    public Set<Map.Entry<V, K>> entrySetFlipped() {
        return this.rEntrySet;
    }

    private class EntryIterator<E, O>
    extends ViewIterator<Map.Entry<E, O>> {
        private Map<O, E> backMap;

        public EntryIterator(Map<E, O> f, Map<O, E> b) {
            super(f.entrySet().iterator());
            this.backMap = b;
        }

        @Override
        public Map.Entry<E, O> next() {
            Map.Entry e = (Map.Entry)super.next();
            return new UnmodifiableEntry(e.getKey(), e.getValue());
        }

        @Override
        public void remove() {
            if (this.removed) {
                return;
            }
            this.iterator.remove();
            this.backMap.remove(((Map.Entry)this.current).getValue());
            this.removed = true;
        }
    }

    private class EntrySet
    extends ViewSet<Map.Entry<K, V>> {
        public EntrySet() {
            super(BiMap.this);
        }

        @Override
        public boolean remove(Object o) {
            try {
                return BiMap.this.remove(((Map.Entry)o).getKey()) != null;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new SmartIterator(new EntryIterator(BiMap.this.forwardMap, BiMap.this.backMap), () -> BiMap.this.modCount);
        }
    }

    private class KeySet
    extends ViewSet<K> {
        public KeySet() {
            super(BiMap.this);
        }

        @Override
        public boolean remove(Object o) {
            return BiMap.this.remove(o) != null;
        }

        @Override
        public Iterator<K> iterator() {
            return new SmartIterator(new SingleIterator(BiMap.this.forwardMap, BiMap.this.backMap), () -> BiMap.this.modCount);
        }
    }

    private class REntrySet
    extends ViewSet<Map.Entry<V, K>> {
        public REntrySet() {
            super(BiMap.this);
        }

        @Override
        public boolean remove(Object o) {
            try {
                return BiMap.this.remove(((Map.Entry)o).getValue()) != null;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public Iterator<Map.Entry<V, K>> iterator() {
            return new SmartIterator(new EntryIterator(BiMap.this.backMap, BiMap.this.forwardMap), () -> BiMap.this.modCount);
        }
    }

    private class SingleIterator<E, O>
    extends ViewIterator<E> {
        private Map<E, O> forwardMap;
        private Map<O, E> backMap;

        public SingleIterator(Map<E, O> f, Map<O, E> b) {
            super(f.keySet().iterator());
            this.forwardMap = f;
            this.backMap = b;
        }

        @Override
        public void remove() {
            if (this.removed) {
                return;
            }
            O o = this.forwardMap.get(this.current);
            this.iterator.remove();
            if (o != null) {
                this.backMap.remove(o);
            }
            this.removed = true;
        }
    }

    private class ValueSet
    extends ViewSet<V> {
        public ValueSet() {
            super(BiMap.this);
        }

        @Override
        public boolean remove(Object o) {
            try {
                return BiMap.this.removeValue(o) != null;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Override
        public Iterator<V> iterator() {
            return new SmartIterator(new SingleIterator(BiMap.this.backMap, BiMap.this.forwardMap), () -> BiMap.this.modCount);
        }
    }
}

