/*
 * Decompiled with CFR 0.152.
 */
package common.dataStructures;

import common.dataStructures.ConsList;
import common.dataStructures.DeArrList;
import common.dataStructures.util.SmartIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class AbsTrie<T, C>
implements Set<T> {
    private TrieNode root = new TrieNode(null, false, null);
    private int size = 0;
    protected int modCount;

    TrieNode getRoot() {
        return this.root;
    }

    protected AbsTrie() {
    }

    protected abstract Iterator<C> toSequence(T var1);

    protected abstract T fromSequence(Iterator<C> var1);

    protected int compareC(C c1, C c2) throws UnsupportedOperationException {
        try {
            Comparable compC1 = (Comparable)c1;
            return compC1.compareTo(c2);
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("Can't compare " + c1 + " and " + c2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(Object o) {
        try {
            Iterator<C> iter = this.toSequence(o);
            TrieNode node = this.root;
            while (true) {
                if (!iter.hasNext()) {
                    return node.isTerminatingNode;
                }
                C c = iter.next();
                if (!node.children.containsKey(c)) {
                    return false;
                }
                node = node.children.get(c);
            }
        }
        catch (ClassCastException c) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(T t) {
        Iterator<C> iter = this.toSequence(t);
        TrieNode node = this.root;
        while (iter.hasNext()) {
            C c = iter.next();
            if (!node.children.containsKey(c)) {
                node.children.put(c, new TrieNode(c, false, node));
            }
            node = node.children.get(c);
        }
        if (node.isTerminatingNode) {
            return false;
        }
        node.isTerminatingNode = true;
        ++this.size;
        ++this.modCount;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        for (T t : c) {
            changed = this.add(t) | changed;
        }
        return changed;
    }

    public List<T> toList() {
        return this.root.buildList(new DeArrList(), new ConsList());
    }

    @Override
    public Iterator<T> iterator() {
        return new SmartIterator<T>(this.toList().iterator(), () -> this.modCount);
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.size()];
        int i = 0;
        for (T t : this) {
            arr[i++] = t;
        }
        return arr;
    }

    @Override
    public <X> X[] toArray(X[] a) {
        X[] arr = a.length >= this.size() ? a : Arrays.copyOf(a, this.size());
        int i = 0;
        for (T t : this) {
            arr[i++] = t;
        }
        return arr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove(Object o) {
        try {
            Iterator<C> iter = this.toSequence(o);
            TrieNode node = this.root;
            while (true) {
                if (!iter.hasNext()) {
                    if (node.isTerminatingNode) break;
                    return false;
                }
                C c = iter.next();
                if (!node.children.containsKey(c)) {
                    return false;
                }
                node = node.children.get(c);
            }
            node.isTerminatingNode = false;
            while (true) {
                if (!node.children.isEmpty()) {
                    --this.size;
                    ++this.modCount;
                    return true;
                }
                TrieNode parent = node.parent;
                parent.children.remove(node.c);
                node = parent;
            }
        }
        catch (ClassCastException c) {
            return false;
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed = this.remove(o) | changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        List<T> contents = this.toList();
        for (T t : contents) {
            if (c.contains(t)) continue;
            changed = this.remove(t) | changed;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.root.children.clear();
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    class TrieNode {
        public final C c;
        boolean isTerminatingNode;
        HashMap<C, TrieNode> children;
        TrieNode parent;

        TrieNode(C c, boolean isTerminatingNode, TrieNode parent) {
            this.c = c;
            this.isTerminatingNode = isTerminatingNode;
            this.children = new HashMap();
            this.parent = parent;
        }

        public String toString() {
            return this.c + "-(term=" + this.isTerminatingNode + ") " + this.children;
        }

        List<T> buildList(List<T> builderList, ConsList<C> prefix) {
            if (this.c != null) {
                prefix = prefix.cons(this.c);
            }
            if (this.isTerminatingNode) {
                builderList.add(AbsTrie.this.fromSequence(prefix.reverse().iterator()));
            }
            DeArrList lst = new DeArrList(this.children.entrySet());
            try {
                Collections.sort(lst, (c1, c2) -> AbsTrie.this.compareC(c1.getKey(), c2.getKey()));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            for (Map.Entry entry : lst) {
                builderList = ((TrieNode)entry.getValue()).buildList(builderList, prefix);
            }
            return builderList;
        }
    }
}

